---
generated_at: 2026-01-22 14:55:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：26-merge_request_status_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ設定**：デフォルト値の確認が必要
  2. **他のステータス変更**：reopen以外のステータス変更への対応確認
  3. **カスタム通知設定キー**：reopen_merge_requestの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` 440-447行目（reopen_mrメソッド）
- E-02: `app/services/notification_service.rb` 862-868行目（reopen_resource_emailメソッド）
- E-03: `app/mailers/emails/merge_requests.rb` 147-153行目（merge_request_status_emailメソッド）
- E-04: `app/views/notify/merge_request_status_email.text.haml` テンプレート内容
- E-05: `app/views/notify/merge_request_status_email.html.haml` HTMLテンプレート
- E-06: `app/services/notification_recipients/build_service.rb` build_recipientsメソッド
- E-07: `app/services/notification_recipients/builder/default.rb` ビルダー実装
- E-08: `app/mailers/notify.rb` メーラー基底クラス
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MRステータス変更時に通知される | E-01 | ○ |
| C-02 | 主にreopen時にトリガーされる | E-01 | ○ |
| C-03 | reopen_resource_emailを内部で呼び出す | E-01, E-02 | ○ |
| C-04 | action: "reopen"で受信者決定 | E-02 863行目 | ○ |
| C-05 | 非同期送信（deliver_later） | E-02 866行目 | ○ |
| C-06 | statusが引数として渡される | E-02 866行目 | ○ |
| C-07 | BuildServiceで受信者決定 | E-02, E-06 | ○ |
| C-08 | 参加者・Watcher・カスタム通知・購読者が受信対象 | E-07 build!メソッド | ○ |
| C-09 | 件名形式：Re: {project} \| {title} ({ref}) | E-03, E-08 | ○ |
| C-10 | テンプレート本文に「was {status} by」を含む | E-04, E-05 | ○ |
| C-11 | mail_answer_threadでスレッド形式メール送信 | E-03 152行目 | ○ |
| C-12 | setup_merge_request_mailでMR情報セットアップ | E-03 148行目 | ○ |
| C-13 | @mr_statusにステータス文字列をセット | E-03 150行目 | ○ |
| C-14 | @updated_byにステータス変更者をセット | E-03 151行目 | ○ |
| C-15 | SentNotification.recordで送信記録 | E-03（setup_merge_request_mail内） | ○ |
| C-16 | カテゴリはMergeRequest | E-09 | ○ |
| C-17 | :merge_request_status_emailが指定される | E-01 444行目 | ○ |
| C-18 | 'reopened'がステータスとして渡される | E-01 445行目 | ○ |
| C-19 | Sidekiqリトライ回数25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数（25回）は一般的な設定だが、GitLab固有の設定確認が必要
  - 候補：config/sidekiq_queues.yml / config/initializers/sidekiq.rb / Gemfile

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は情報通知のみで、業務クリティカルな処理は含まない
- 0: 低リスク - ユーザー名はsanitize_nameでサニタイズされる

## 6) レビュアーチェックリスト（最小）
- [ ] reopen_mrメソッドの実装が設計書と一致しているか確認
- [ ] reopen_resource_emailの呼び出しパラメータを確認
- [ ] テンプレートファイルの存在と内容を確認
- [ ] @mr_statusと@updated_byのセットが正しく行われているか確認
- [ ] reopen以外のステータス変更で本通知が使用されるか確認
