---
generated_at: 2026-01-22 15:00:00
metrics:
  claims_total: 21
  claims_with_evidence: 20
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：27-merge_request_unmergeable_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：20 / 21、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ設定**：デフォルト値の確認が必要
  2. **トリガータイミング**：マージ不可検出の具体的なタイミング確認
  3. **Merge Train連携**：Enterprise機能との連携確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` 332-334行目（merge_request_unmergeableメソッド）
- E-02: `app/services/notification_service.rb` 870-876行目（merge_request_unmergeable_emailメソッド）
- E-03: `app/services/notification_recipients/build_service.rb` 24-26行目（build_merge_request_unmergeable_recipientsメソッド）
- E-04: `app/services/notification_recipients/builder/merge_request_unmergeable.rb` MergeRequestUnmergeableビルダー
- E-05: `app/mailers/emails/merge_requests.rb` 155-159行目（merge_request_unmergeable_emailメソッド）
- E-06: `app/views/notify/merge_request_unmergeable_email.text.haml` テンプレート内容
- E-07: `app/views/notify/merge_request_unmergeable_email.html.haml` HTMLテンプレート
- E-08: `app/models/merge_request.rb` 1032-1040行目（merge_participantsメソッド）
- E-09: `app/mailers/notify.rb` メーラー基底クラス
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MRマージ不可時に通知される | E-01 | ○ |
| C-02 | NotificationService.merge_request_unmergeableで処理開始 | E-01 | ○ |
| C-03 | merge_request_unmergeable_emailを内部で呼び出す | E-01, E-02 | ○ |
| C-04 | build_merge_request_unmergeable_recipientsで受信者決定 | E-02, E-03 | ○ |
| C-05 | MergeRequestUnmergeableビルダーが使用される | E-03, E-04 | ○ |
| C-06 | merge_participantsが対象 | E-04 12-15行目 | ○ |
| C-07 | authorは必ず含まれる | E-08 1033行目 | ○ |
| C-08 | auto_merge_enabled時はmerge_userも含まれる | E-08 1035-1037行目 | ○ |
| C-09 | acting_userがnil | E-04 22-24行目 | ○ |
| C-10 | 非同期送信（deliver_later） | E-02 874行目 | ○ |
| C-11 | 件名形式：Re: {project} \| {title} ({ref}) | E-05, E-09 | ○ |
| C-12 | テンプレート本文に「can no longer be merged due to conflict」を含む | E-06, E-07 | ○ |
| C-13 | mail_answer_threadでスレッド形式メール送信 | E-05 158行目 | ○ |
| C-14 | setup_merge_request_mailでMR情報セットアップ | E-05 156行目 | ○ |
| C-15 | SentNotification.recordで送信記録 | E-05（setup_merge_request_mail内） | ○ |
| C-16 | 送信者にauthor_idが使用される | E-05 158行目 | ○ |
| C-17 | :participatingレベルで追加される | E-04 14行目 | ○ |
| C-18 | custom_actionは:unmergeable_merge_request | E-04 17-19行目 | ○ |
| C-19 | 閲覧権限チェックが行われる | E-08 1039行目 | ○ |
| C-20 | カテゴリはMergeRequest | E-10 | ○ |
| C-21 | Sidekiqリトライ回数25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数（25回）は一般的な設定だが、GitLab固有の設定確認が必要
  - 候補：config/sidekiq_queues.yml / config/initializers/sidekiq.rb / Gemfile

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は情報通知のみで、業務クリティカルな処理は含まない
- 0: 低リスク - ユーザー名はsanitize_nameでサニタイズされる
- 1: 中リスク - マージ不可検出のトリガータイミングを確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] merge_request_unmergeableメソッドの実装が設計書と一致しているか確認
- [ ] MergeRequestUnmergeableビルダーの実装を確認
- [ ] merge_participantsメソッドの実装を確認
- [ ] テンプレートファイルの存在と内容を確認
- [ ] マージ不可検出の具体的なトリガーポイントを確認
