---
generated_at: 2026-01-22 15:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：28-resolved_all_discussions_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ設定**：デフォルト値の確認が必要
  2. **トリガータイミング**：全ディスカッション解決の検出ロジック確認
  3. **マージ要件との連携**：プロジェクト設定との関係確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` 449-458行目（resolve_all_discussionsメソッド）
- E-02: `app/mailers/emails/merge_requests.rb` 161-166行目（resolved_all_discussions_emailメソッド）
- E-03: `app/views/notify/resolved_all_discussions_email.text.erb` テンプレート内容
- E-04: `app/services/notification_recipients/build_service.rb` build_recipientsメソッド
- E-05: `app/services/notification_recipients/builder/default.rb` ビルダー実装
- E-06: `app/mailers/notify.rb` メーラー基底クラス
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全ディスカッション解決時に通知される | E-01 | ○ |
| C-02 | NotificationService.resolve_all_discussionsで処理開始 | E-01 | ○ |
| C-03 | action: "resolve_all_discussions"で受信者決定 | E-01 453行目 | ○ |
| C-04 | 非同期送信（deliver_later） | E-01 456行目 | ○ |
| C-05 | BuildServiceで受信者決定 | E-01, E-04 | ○ |
| C-06 | 参加者・Watcher・カスタム通知・購読者が受信対象 | E-05 build!メソッド | ○ |
| C-07 | current_userは送信対象から除外 | E-05 skip_current_user: true | ○ |
| C-08 | 件名形式：Re: {project} \| {title} ({ref}) | E-02, E-06 | ○ |
| C-09 | テンプレート本文に「All discussions」「were resolved by」を含む | E-03 | ○ |
| C-10 | mail_answer_threadでスレッド形式メール送信 | E-02 165行目 | ○ |
| C-11 | setup_merge_request_mailでMR情報セットアップ | E-02 162行目 | ○ |
| C-12 | @resolved_byに解決者をセット | E-02 164行目 | ○ |
| C-13 | SentNotification.recordで送信記録 | E-02（setup_merge_request_mail内） | ○ |
| C-14 | User.findでresolved_by取得 | E-02 164行目 | ○ |
| C-15 | カテゴリはMergeRequest | E-07 | ○ |
| C-16 | resolved_by_user_idが送信者として使用される | E-02 165行目 | ○ |
| C-17 | merge_request_urlをテンプレートに含む | E-03 | ○ |
| C-18 | Sidekiqリトライ回数25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数（25回）は一般的な設定だが、GitLab固有の設定確認が必要
  - 候補：config/sidekiq_queues.yml / config/initializers/sidekiq.rb / Gemfile

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は情報通知のみで、業務クリティカルな処理は含まない
- 0: 低リスク - ユーザー名はsanitize_nameでサニタイズされる

## 6) レビュアーチェックリスト（最小）
- [ ] resolve_all_discussionsメソッドの実装が設計書と一致しているか確認
- [ ] テンプレートファイルの存在と内容を確認
- [ ] @resolved_byのセットが正しく行われているか確認
- [ ] 全ディスカッション解決の検出ロジックを確認（呼び出し元）
- [ ] マージ要件「すべてのディスカッションの解決」との連携を確認
