---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-new_mention_in_issue_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Mentionable Concern実装詳細**：mentioned_usersメソッドの完全な実装詳細
  2. **新規メンション検出ロジック**：Issue更新前後の比較ロジック
  3. **テンプレート再利用パターン**：renderディレクティブの動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` - new_mentions_in_issueメソッド（217-224行目）、new_mentions_in_resource_email（818-830行目）
- E-02: `app/mailers/emails/issues.rb` - new_mention_in_issue_emailメソッド（24-34行目）
- E-03: `app/views/notify/new_mention_in_issue_email.html.haml` - メールテンプレート（全5行）
- E-04: `app/views/notify/new_issue_email.html.haml` - 再利用されるベーステンプレート
- E-05: `app/services/notification_recipients/builder/default.rb` - 受信者構築ロジック
- E-06: `app/mailers/notify.rb` - mail_answer_thread（188-196行目）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | new_mention_in_issue_emailはメンション通知を送信 | E-01, E-02 | ○ |
| C-02 | NotificationService.new_mentions_in_issue()がエントリーポイント | E-01 (217行目) | ○ |
| C-03 | new_mentioned_usersでフィルタリング | E-01 (825行目) | ○ |
| C-04 | 非同期送信（deliver_later）を使用 | E-01 (828行目) | ○ |
| C-05 | updated_by_user_idがsenderとして使用される | E-02 (24行目, 26-33行目) | ○ |
| C-06 | setup_issue_mailでインスタンス変数を設定 | E-02 (25行目) | ○ |
| C-07 | mail_answer_threadでスレッド返信形式 | E-02 (26-33行目), E-06 | ○ |
| C-08 | テンプレートで"You have been mentioned"表示 | E-03 (2行目) | ○ |
| C-09 | new_issue_emailテンプレートをrender再利用 | E-03 (4行目) | ○ |
| C-10 | action: "new"で基本受信者リスト構築 | E-01 (824行目) | ○ |
| C-11 | 4引数でメソッド呼び出し | E-02 (24行目) | ○ |
| C-12 | can_trigger_notifications?チェック実行 | E-01 (819-822行目) | ○ |
| C-13 | NotificationReason::MENTIONEDが使用される | E-05 (110行目参照) | ○ |
| C-14 | X-GitLab-ConfidentialIssueヘッダー設定 | E-02 (issue_thread_options) | ○ |
| C-15 | 件名にRe:プレフィックス付与 | E-06 (193行目) | ○ |
| C-16 | Issue説明文をMarkdownレンダリング | E-04 (10-12行目) | ○ |
| C-17 | 担当者情報を条件付き表示 | E-04 (6-8行目) | ○ |
| C-18 | SentNotification.recordで送信記録作成 | E-02 (setup_issue_mail内) | ○ |
| C-19 | skip_current_user: trueで更新者除外 | E-01 (暗黙的default) | ○ |
| C-20 | 受信者の通知レベルチェック | E-05 (filter!メソッド) | ○ |
| C-21 | プロジェクトヘッダー設定 | E-06 (add_project_headers) | ○ |
| C-22 | Mentionable Concernによるメンション検出詳細 | **根拠なし（実装詳細未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- Mentionable Concernの完全な実装詳細
  - 候補：app/models/concerns/mentionable.rb
- 新規メンション検出ロジック（Issue更新前後の比較）
  - 候補：Issues::UpdateService / Issuable Concern

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信処理の基本フロー
- 0: 低リスク - テンプレート再利用パターン
- 1: 中リスク - メンション検出ロジックの完全性
- 0: 低リスク - フィルタリングロジック

## 6) レビュアーチェックリスト（最小）
- [ ] Mentionableモジュールのmentioned_usersメソッド実装を確認
- [ ] 新規メンション検出ロジック（差分検出）の動作確認
- [ ] テンプレートのrenderディレクティブが正しく動作するか確認
- [ ] updated_by_user_idがsenderとして正しく使用されているか確認
- [ ] 既存メンションユーザーへの重複通知が防止されているか確認
