---
generated_at: 2026-01-22 15:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-merge_requests_csv_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **CSVエクスポート項目**：header_to_value_hashの全カラムを確認
  2. **トランケーション処理**：TARGET_FILESIZEによる制限動作確認
  3. **同期送信**：deliver_nowによる即時送信の影響確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/merge_requests/export_csv_service.rb` 1-39行目（ExportCsvService全体）
- E-02: `app/services/export_csv/base_service.rb` 1-56行目（BaseService全体）
- E-03: `app/mailers/emails/merge_requests.rb` 175-188行目（merge_requests_csv_emailメソッド）
- E-04: `app/mailers/notify.rb` 276-281行目（email_with_layoutメソッド）
- E-05: `app/views/notify/merge_requests_csv_email.text.erb` テンプレート内容
- E-06: `app/views/notify/merge_requests_csv_email.html.haml` HTMLテンプレート
- E-07: `app/views/notify/_issuable_csv_export.text.erb` パーシャルテンプレート
- E-08: `app/views/notify/_issuable_csv_export.html.haml` パーシャルテンプレート（HTML）
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSVエクスポート完了時にメール送信される | E-01 8-10行目 | ○ |
| C-02 | MergeRequests::ExportCsvService.emailで処理開始 | E-01 8-10行目 | ○ |
| C-03 | Notify.merge_requests_csv_emailを呼び出す | E-01 9行目 | ○ |
| C-04 | deliver_nowで同期送信される | E-01 9行目 | ○ |
| C-05 | user.notification_email_forで送信先決定 | E-03 186行目 | ○ |
| C-06 | @projectがセットされる | E-03 176行目 | ○ |
| C-07 | @countがrows_expectedからセットされる | E-03 177行目 | ○ |
| C-08 | @written_countがrows_writtenからセットされる | E-03 178行目 | ○ |
| C-09 | @truncatedがセットされる | E-03 179行目 | ○ |
| C-10 | @size_limitがTARGET_FILESIZEから計算される | E-03 180-181行目, E-02 6行目 | ○ |
| C-11 | TARGET_FILESIZEは15MB | E-02 6行目 | ○ |
| C-12 | CSVファイル名形式：{project_path}_merge_requests_{date}.csv | E-03 183行目 | ○ |
| C-13 | CSVファイルがattachmentsで添付される | E-03 184行目 | ○ |
| C-14 | email_with_layoutでメール送信 | E-03 185-187行目 | ○ |
| C-15 | 件名形式：{project_name} \| Exported merge requests | E-03 187行目 | ○ |
| C-16 | テンプレートで_issuable_csv_exportをrender | E-05, E-06 | ○ |
| C-17 | type: :merge_requestが渡される | E-05, E-06 | ○ |
| C-18 | トランケーション時に警告メッセージ表示 | E-07 5-7行目 | ○ |
| C-19 | CSVにTitle, Description, MR IID等20カラム含む | E-01 14-36行目 | ○ |
| C-20 | header_to_value_hashでカラム定義 | E-01 14-36行目 | ○ |
| C-21 | カテゴリはMergeRequest | E-09 | ○ |
| C-22 | ExportCsv::BaseServiceを継承 | E-01 4行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知はエクスポート要求者本人のみに送信される
- 0: 低リスク - CSVデータはユーザーの閲覧権限内のMRのみ
- 1: 中リスク - 同期送信（deliver_now）のため、送信エラー時の処理確認推奨
- 1: 中リスク - 大量データエクスポート時のパフォーマンス影響確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] export_csv_service.rbのemailメソッドが設計書と一致しているか確認
- [ ] merge_requests_csv_emailメソッドの実装を確認
- [ ] header_to_value_hashの全カラム定義を確認
- [ ] テンプレートファイルの存在と内容を確認
- [ ] トランケーション処理の動作確認
- [ ] deliver_nowの同期送信が適切か確認
- [ ] 15MB制限の妥当性確認
