---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-approved_merge_request_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **リトライ回数（Sidekiqデフォルト25回）**：Sidekiq設定ファイル未確認
  2. **EE版承認数表示の詳細仕様**：EEモジュール未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/merge_requests/approval_service.rb` (1-59行目)
- E-02: `app/services/notification_service.rb` (721-727行目, 934-948行目)
- E-03: `app/mailers/emails/merge_requests.rb` (190-225行目)
- E-04: `app/mailers/notify.rb` (1-320行目)
- E-05: `app/views/notify/approved_merge_request_email.html.haml` (1-76行目)
- E-06: `app/views/notify/approved_merge_request_email.text.haml` (1-10行目)
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` (32行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はapproved_merge_request_email | E-07 | ○ |
| C-02 | Merge Request承認時に送信される | E-01 (5-37行目) | ○ |
| C-03 | NotificationService#approve_mrを経由 | E-02 (721-723行目) | ○ |
| C-04 | 非同期送信（deliver_later） | E-02 (938行目) | ○ |
| C-05 | 受信者はBuildServiceで決定 | E-02 (935行目) | ○ |
| C-06 | action: 'approve'で受信者フィルタ | E-02 (935行目) | ○ |
| C-07 | メール件名にMRタイトルと参照番号を含む | E-03 (221行目) | ○ |
| C-08 | setup_merge_request_mailで共通セットアップ | E-03 (191行目, 206-215行目) | ○ |
| C-09 | @approved_byに承認者を設定 | E-03 (193行目) | ○ |
| C-10 | mail_answer_threadでスレッド形式送信 | E-03 (194行目) | ○ |
| C-11 | HTML版テンプレートで承認数表示（EE） | E-05 (10-13行目) | ○ |
| C-12 | テキスト版で承認者名とMR URLを表示 | E-06 (1-3行目) | ○ |
| C-13 | SentNotification.recordで送信記録 | E-03 (214行目) | ○ |
| C-14 | プロジェクト、ブランチ、作成者情報を表示 | E-05 (33-63行目) | ○ |
| C-15 | アサイン先、レビュアーを表示 | E-05 (65-69行目) | ○ |
| C-16 | mailerレイアウトを使用 | E-03 (8-12行目) | ○ |
| C-17 | EventStore経由でApprovedEvent発行 | E-01 (30-35行目) | ○ |
| C-18 | 承認可能かeligible_for_approval?で確認 | E-01 (6行目, 42-44行目) | ○ |
| C-19 | マージ済みの場合は送信しない | E-01 (7行目) | ○ |
| C-20 | notification_email_forで送信先取得 | E-03 (220行目) | ○ |
| C-21 | X-GitLab-NotificationReasonヘッダー設定 | E-03 (222行目) | ○ |
| C-22 | senderメソッドで送信元を設定 | E-03 (219行目), E-04 (83-96行目) | ○ |
| C-23 | Reply-Toヘッダーで返信可能 | E-04 (146-156行目) | ○ |
| C-24 | リトライ回数は25回 | **根拠なし** | △ |
| C-25 | EE版approvals_required仕様詳細 | **根拠なし（EEモジュール）** | △ |

## 4) 不足情報（Unknown / Missing）
- **Sidekiqリトライ設定**: Sidekiqの設定ファイルを確認していないため、デフォルト25回という記載は一般的な知識に基づく
  - 候補：config/sidekiq.yml / config/initializers/sidekiq.rb
- **EE版承認ルール詳細**: EEモジュール（ee/app/）を確認していないため、approvals_requiredの詳細仕様は未確認
  - 候補：ee/app/models/merge_request.rb / ee/app/services/merge_requests/approval_service.rb

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的な通知フローは全てコードで確認済み
- **1（中リスク）**: EE版の承認ルール機能については追加確認推奨
- **0（低リスク）**: テンプレート構造はソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 通知トリガーがApprovalService#executeであることを確認
- [ ] 受信者決定ロジック（action: 'approve'）が正しいことを確認
- [ ] EE版の承認数表示が実際の動作と一致することを確認
- [ ] Sidekiqのリトライ設定を確認（必要に応じて修正）
