---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-unapproved_merge_request_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **EE版承認数表示の詳細仕様**：EEモジュール未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` (725-727行目, 942-948行目)
- E-02: `app/mailers/emails/merge_requests.rb` (197-202行目, 8-12行目)
- E-03: `app/mailers/notify.rb` (1-320行目)
- E-04: `app/views/notify/unapproved_merge_request_email.html.haml` (1-80行目)
- E-05: `app/views/notify/unapproved_merge_request_email.text.haml` (1-10行目)
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` (33行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はunapproved_merge_request_email | E-06 | ○ |
| C-02 | 承認取り消し時に送信される | E-01 (725-727行目) | ○ |
| C-03 | NotificationService#unapprove_mrを経由 | E-01 (725-727行目) | ○ |
| C-04 | 非同期送信（deliver_later） | E-01 (946行目) | ○ |
| C-05 | 受信者はBuildServiceで決定 | E-01 (943行目) | ○ |
| C-06 | action: 'unapprove'で受信者フィルタ | E-01 (943行目) | ○ |
| C-07 | メール件名にMRタイトルと参照番号を含む | E-02 (217-224行目) | ○ |
| C-08 | setup_merge_request_mailで共通セットアップ | E-02 (198行目) | ○ |
| C-09 | @unapproved_byに取り消し者を設定 | E-02 (200行目) | ○ |
| C-10 | mail_answer_threadでスレッド形式送信 | E-02 (201行目) | ○ |
| C-11 | HTML版テンプレートで承認数表示（EE） | E-04 (9-14行目) | ○ |
| C-12 | テキスト版で取り消し者名とMR URLを表示 | E-05 (1-3行目) | ○ |
| C-13 | SentNotification.recordで送信記録 | E-02 (214行目) | ○ |
| C-14 | 赤色背景（#d22f57）で警告表示 | E-04 (2行目) | ○ |
| C-15 | プロジェクト、ブランチ、作成者情報を表示 | E-04 (33-67行目) | ○ |
| C-16 | アサイン先、レビュアーを表示 | E-04 (69-73行目) | ○ |
| C-17 | mailerレイアウトを使用 | E-02 (8-12行目) | ○ |
| C-18 | notification_email_forで送信先取得 | E-02 (220行目) | ○ |
| C-19 | X-GitLab-NotificationReasonヘッダー設定 | E-02 (222行目) | ○ |
| C-20 | senderメソッドで送信元を設定 | E-02 (219行目) | ○ |
| C-21 | Reply-Toヘッダーで返信可能 | E-03 (146-156行目) | ○ |
| C-22 | EE版approvals_required仕様詳細 | **根拠なし（EEモジュール）** | △ |

## 4) 不足情報（Unknown / Missing）
- **EE版承認ルール詳細**: EEモジュール（ee/app/）を確認していないため、approvals_requiredの詳細仕様は未確認
  - 候補：ee/app/models/merge_request.rb / ee/app/views/notify/

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的な通知フローは全てコードで確認済み
- **1（中リスク）**: EE版の承認ルール機能については追加確認推奨
- **0（低リスク）**: テンプレート構造はソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 通知トリガーが承認取り消し操作であることを確認
- [ ] 受信者決定ロジック（action: 'unapprove'）が正しいことを確認
- [ ] EE版の承認数表示が実際の動作と一致することを確認
- [ ] 赤色背景の視覚表現が意図通りであることを確認
