---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-note_commit_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` (469-477行目, 884-891行目)
- E-02: `app/mailers/emails/notes.rb` (5-11行目, 71-101行目)
- E-03: `app/mailers/notify.rb` (198-208行目)
- E-04: `app/views/notify/note_commit_email.html.haml` (1行目)
- E-05: `app/views/notify/note_commit_email.text.erb` (1行目)
- E-06: `app/views/notify/_note_email.html.haml` (1-40行目)
- E-07: `app/views/notify/_note_email.text.erb` (1-32行目)
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` (34行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はnote_commit_email | E-08 | ○ |
| C-02 | コミットへのコメント追加時に送信 | E-01 (469-477行目), E-02 (5行目) | ○ |
| C-03 | NotificationService#new_noteを経由 | E-01 (469-477行目) | ○ |
| C-04 | 非同期送信（deliver_later） | E-01 (889行目) | ○ |
| C-05 | build_new_note_recipientsで受信者決定 | E-01 (887行目) | ○ |
| C-06 | システムノートは除外される | E-01 (473行目) | ○ |
| C-07 | メール件名にコミットタイトルを含む | E-02 (85行目) | ○ |
| C-08 | setup_note_mailで共通セットアップ | E-02 (6行目, 92-101行目) | ○ |
| C-09 | @commit = @note.noteableでコミット取得 | E-02 (8行目) | ○ |
| C-10 | project_commit_urlでターゲットURL生成 | E-02 (9行目) | ○ |
| C-11 | mail_answer_note_threadでスレッド送信 | E-02 (10行目), E-03 (198-208行目) | ○ |
| C-12 | 共通パーシャル_note_emailを使用 | E-04, E-05 | ○ |
| C-13 | diff_discussionの場合はコード差分表示 | E-06 (27-36行目) | ○ |
| C-14 | show_diff_preview_in_email?で表示制御 | E-06 (27行目), E-07 (25行目) | ○ |
| C-15 | markdown変換してコメント本文表示 | E-06 (39行目) | ○ |
| C-16 | SentNotification.record_noteで送信記録 | E-02 (100行目) | ○ |
| C-17 | notification_email_forで送信先取得 | E-02 (84行目) | ○ |
| C-18 | X-GitLab-NotificationReasonヘッダー | E-02 (86行目) | ○ |
| C-19 | X-GitLab-Discussion-IDヘッダー | E-03 (203行目) | ○ |
| C-20 | Message-IDにNote用IDを設定 | E-03 (199行目) | ○ |
| C-21 | In-Reply-Toで参照チェーン設定 | E-03 (200行目) | ○ |
| C-22 | Referencesにnote参照を設定 | E-03 (201行目) | ○ |
| C-23 | コメント投稿者名をsenderに設定 | E-02 (83行目) | ○ |
| C-24 | noteable_ability_nameでメソッド名決定 | E-01 (885行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張がソースコードで確認済み
- **0（低リスク）**: テンプレート構造も確認済み
- **0（低リスク）**: 共通パーシャルの使用も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] note_commit_emailがCommitへのコメント専用であることを確認
- [ ] 共通パーシャル_note_emailの使用が正しいことを確認
- [ ] diff表示設定（show_diff_preview_in_email?）が意図通りであることを確認
- [ ] ディスカッションヘッダー（X-GitLab-Discussion-ID）の設定を確認
