---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-note_merge_request_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` (469-477行目, 884-891行目)
- E-02: `app/mailers/emails/notes.rb` (28-34行目)
- E-03: `app/views/notify/note_merge_request_email.html.haml` (1行目)
- E-04: `app/views/notify/_note_email.html.haml` (1-40行目)
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` (36行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はnote_merge_request_email | E-05 | ○ |
| C-02 | MRへのコメント追加時に送信 | E-01, E-02 (28行目) | ○ |
| C-03 | NotificationService#new_noteを経由 | E-01 (469-477行目) | ○ |
| C-04 | 非同期送信（deliver_later） | E-01 (889行目) | ○ |
| C-05 | build_new_note_recipientsで受信者決定 | E-01 (887行目) | ○ |
| C-06 | @merge_request = @note.noteableでMR取得 | E-02 (31行目) | ○ |
| C-07 | project_merge_request_urlでURL生成 | E-02 (32行目) | ○ |
| C-08 | mail_answer_note_threadでスレッド送信 | E-02 (33行目) | ○ |
| C-09 | 共通パーシャル_note_emailを使用 | E-03, E-04 | ○ |
| C-10 | diff_discussionの場合コード差分表示 | E-04 (27-36行目) | ○ |
| C-11 | show_diff_preview_in_email?で表示制御 | E-04 (27行目) | ○ |
| C-12 | setup_note_mailで共通セットアップ | E-02 (29行目) | ○ |
| C-13 | システムノートは除外 | E-01 (473行目) | ○ |
| C-14 | X-GitLab-Discussion-IDヘッダー | E-04 親クラス参照 | ○ |
| C-15 | note_thread_optionsでヘッダー設定 | E-02 (71-90行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] note_merge_request_emailがMRへのコメント専用であることを確認
- [ ] diff discussion時のコード差分表示が正しいことを確認
- [ ] 共通パーシャル_note_emailの使用が正しいことを確認
