---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-pipeline_success_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` (558-559行目, 562-584行目, 950-958行目)
- E-02: `app/mailers/emails/pipelines.rb` (5-7行目, 19-57行目)
- E-03: `app/views/notify/pipeline_success_email.html.haml` (1行目)
- E-04: `app/views/notify/pipeline_success_email.text.erb` (1行目)
- E-05: `app/views/notify/_successful_pipeline.html.haml` (1-122行目)
- E-06: `app/views/notify/_successful_pipeline.text.erb` (1-36行目)
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` (40行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はpipeline_success_email | E-07 | ○ |
| C-02 | パイプライン成功時に送信 | E-01, E-02 (5-7行目) | ○ |
| C-03 | NotificationService#pipeline_finishedを経由 | E-01 (562-584行目) | ○ |
| C-04 | 非同期送信（deliver_later） | E-01 (582行目) | ○ |
| C-05 | emails_disabled?チェック | E-01 (565行目) | ○ |
| C-06 | email_template_nameでテンプレート名生成 | E-01 (558-559行目, 569行目) | ○ |
| C-07 | notifiable_usersで受信者決定 | E-01 (573-579行目) | ○ |
| C-08 | custom_action: :success_pipeline | E-01 (575行目) | ○ |
| C-09 | pipeline_mailで共通処理 | E-02 (5-7行目, 19-36行目) | ○ |
| C-10 | @project = pipeline.project | E-02 (22行目) | ○ |
| C-11 | @merge_request取得（条件分岐） | E-02 (25-29行目) | ○ |
| C-12 | add_pipeline_headersでヘッダー設定 | E-02 (31行目, 43-47行目) | ○ |
| C-13 | email_with_layoutで送信 | E-02 (33-35行目) | ○ |
| C-14 | 件名にブランチ名とSHA含む | E-02 (49-55行目) | ○ |
| C-15 | 共通パーシャル_successful_pipelineを使用 | E-03, E-04 | ○ |
| C-16 | 緑色バナー表示 | E-05 (3行目) | ○ |
| C-17 | ジョブ数とステージ数表示 | E-05 (119-121行目) | ○ |
| C-18 | コミット作成者とコミッター表示 | E-05 (59-92行目) | ○ |
| C-19 | パイプライン名またはID表示 | E-05 (103行目) | ○ |
| C-20 | pipeline_notification_statusでステータス決定 | E-01 (568行目, 950-958行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] pipeline_success_emailがパイプライン成功専用であることを確認
- [ ] 受信者決定ロジック（custom_action: :success_pipeline）が正しいことを確認
- [ ] テンプレートの表示内容が意図通りであることを確認
- [ ] パイプラインヘッダー設定が正しいことを確認
