---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-reassigned_issue_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` - reassigned_issueメソッド（243-263行目）
- E-02: `app/mailers/emails/issues.rb` - reassigned_issue_emailメソッド（37-53行目）
- E-03: `app/views/notify/_reassigned_issuable_email.html.haml` - 共通テンプレート（全13行）
- E-04: `app/services/notification_recipients/builder/default.rb` - reassignアクション処理（33-36行目）
- E-05: `app/models/issue.rb` - assignees関連（91-96行目）
- E-06: `app/mailers/notify.rb` - mail_answer_thread（188-196行目）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | reassigned_issue_emailは担当者変更通知を送信 | E-01, E-02 | ○ |
| C-02 | NotificationService.reassigned_issue()がエントリーポイント | E-01 (243行目) | ○ |
| C-03 | 非同期送信（deliver_later）を使用 | E-01 (260行目) | ○ |
| C-04 | action: "reassign"で受信者構築 | E-01 (247行目) | ○ |
| C-05 | previous_assigneesオプションで以前の担当者指定 | E-01 (248行目), E-04 (34行目) | ○ |
| C-06 | 以前の担当者に:mentionレベルで通知 | E-04 (34行目) | ○ |
| C-07 | 新担当者にNotificationReason::ASSIGNEDで通知 | E-04 (35行目) | ○ |
| C-08 | 5引数でメソッド呼び出し | E-02 (37行目) | ○ |
| C-09 | User.where(id:).order(:id)で以前の担当者取得 | E-02 (41行目) | ○ |
| C-10 | @added_assignees = current - previous | E-02 (42行目) | ○ |
| C-11 | @removed_assignees = previous - current | E-02 (43行目) | ○ |
| C-12 | setup_issue_mailでインスタンス変数設定 | E-02 (38行目) | ○ |
| C-13 | mail_answer_threadでスレッド返信形式 | E-02 (45-52行目), E-06 | ○ |
| C-14 | テンプレートでto_sentence使用 | E-03 (1行目) | ○ |
| C-15 | n_関数で複数形対応 | E-03 (6行目) | ○ |
| C-16 | 担当者追加メッセージ表示 | E-03 (4-6行目) | ○ |
| C-17 | 担当者削除メッセージ表示 | E-03 (7-9行目) | ○ |
| C-18 | 全担当者削除メッセージ表示 | E-03 (10-12行目) | ○ |
| C-19 | X-GitLab-ConfidentialIssueヘッダー設定 | E-02 (issue_thread_options) | ○ |
| C-20 | 件名にRe:プレフィックス付与 | E-06 (193行目) | ○ |
| C-21 | SentNotification.recordで送信記録作成 | E-02 (setup_issue_mail内) | ○ |
| C-22 | previous_assignee_ids計算 | E-01 (251行目) | ○ |
| C-23 | has_many :assignees関連 | E-05 (96行目) | ○ |
| C-24 | has_many :issue_assignees関連 | E-05 (91行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信処理の基本フロー
- 0: 低リスク - 担当者差分計算ロジック
- 0: 低リスク - テンプレート表示ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] @added_assignees, @removed_assigneesの計算が正しいか確認
- [ ] 複数形/単数形の表現が正しく表示されるか確認
- [ ] 以前の担当者と新担当者の両方に通知されるか確認
- [ ] 全担当者削除時のメッセージが適切か確認
