---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-pipeline_failed_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` (558-559行目, 562-584行目, 950-958行目)
- E-02: `app/mailers/emails/pipelines.rb` (9-11行目, 19-57行目)
- E-03: `app/views/notify/pipeline_failed_email.html.haml` (1-116行目)
- E-04: `app/views/notify/pipeline_failed_email.text.erb` (1-37行目)
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` (41行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はpipeline_failed_email | E-05 | ○ |
| C-02 | パイプライン失敗時に送信 | E-01, E-02 (9-11行目) | ○ |
| C-03 | NotificationService#pipeline_finishedを経由 | E-01 (562-584行目) | ○ |
| C-04 | 非同期送信（deliver_later） | E-01 (582行目) | ○ |
| C-05 | emails_disabled?チェック | E-01 (565行目) | ○ |
| C-06 | email_template_nameでテンプレート名生成 | E-01 (558-559行目, 569行目) | ○ |
| C-07 | notifiable_usersで受信者決定 | E-01 (573-579行目) | ○ |
| C-08 | custom_action: :failed_pipeline | E-01 (575行目) | ○ |
| C-09 | pipeline_mailで共通処理（status='Failed'） | E-02 (9-11行目, 19-36行目) | ○ |
| C-10 | @project = pipeline.project | E-02 (22行目) | ○ |
| C-11 | @merge_request取得（条件分岐） | E-02 (25-29行目) | ○ |
| C-12 | add_pipeline_headersでヘッダー設定 | E-02 (31行目, 43-47行目) | ○ |
| C-13 | email_with_layoutで送信 | E-02 (33-35行目) | ○ |
| C-14 | 件名にブランチ名とSHA含む | E-02 (49-55行目) | ○ |
| C-15 | 赤色背景（#d22f57）表示 | E-03 (2行目) | ○ |
| C-16 | @pipeline.latest_statuses.failedで失敗ジョブ取得 | E-03 (115行目), E-04 (32行目) | ○ |
| C-17 | 失敗ジョブのステージ名表示 | E-04 (37行目) | ○ |
| C-18 | 失敗ジョブのジョブ名表示 | E-04 (38行目) | ○ |
| C-19 | パイプライン名またはID表示 | E-03 (9行目), E-04 (25行目) | ○ |
| C-20 | pipeline_notification_statusでステータス決定 | E-01 (568行目, 950-958行目) | ○ |
| C-21 | _failed_buildsパーシャル使用 | E-03 (115行目) | ○ |
| C-22 | 失敗ジョブ数表示 | E-04 (33行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] pipeline_failed_emailがパイプライン失敗専用であることを確認
- [ ] 受信者決定ロジック（custom_action: :failed_pipeline）が正しいことを確認
- [ ] 失敗ジョブ一覧の取得と表示が正しいことを確認
- [ ] 赤色背景の視覚表現が意図通りであることを確認
