---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：41-pipeline_fixed_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **レート制限の具体値**：インスタンス設定に依存するため実装からは特定不可
  2. **Sidekiqリトライ回数**：デフォルト値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/emails/pipelines.rb` 13-15行目 - pipeline_fixed_emailメソッド定義
- E-02: `app/mailers/emails/pipelines.rb` 19-36行目 - pipeline_mailメソッド定義
- E-03: `app/services/notification_service.rb` 562-584行目 - pipeline_finishedメソッド
- E-04: `app/services/notification_service.rb` 558-560行目 - email_template_name メソッド
- E-05: `app/services/notification_service.rb` 950-958行目 - pipeline_notification_statusメソッド
- E-06: `app/views/notify/pipeline_fixed_email.html.haml` - HTMLテンプレート
- E-07: `app/views/notify/pipeline_fixed_email.text.erb` - テキストテンプレート
- E-08: `app/views/notify/_successful_pipeline.html.haml` - 共通パーシャル（HTML）
- E-09: `app/views/notify/_successful_pipeline.text.erb` - 共通パーシャル（テキスト）
- E-10: `app/models/ci/pipeline.rb` - パイプラインモデル定義
- E-11: `app/mailers/notify.rb` 276-281行目 - email_with_layoutメソッド
- E-12: `app/mailers/emails/pipelines.rb` 43-47行目 - add_pipeline_headers

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pipeline_fixed_emailメソッドが存在する | E-01 | ○ |
| C-02 | pipeline_mailメソッドを'Fixed'ステータスで呼び出す | E-01 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-03 | ○ |
| C-04 | ref_statusが'fixed'の場合にトリガーされる | E-03, E-05 | ○ |
| C-05 | プロジェクトのemails_disabled?チェックが行われる | E-03 | ○ |
| C-06 | 件名形式が「プロジェクト名 \| Fixed pipeline for ブランチ名 \| コミットSHA」 | E-02 | ○ |
| C-07 | @project、@pipeline、@merge_request変数が設定される | E-02 | ○ |
| C-08 | X-GitLab-Pipeline-Idヘッダーが追加される | E-12 | ○ |
| C-09 | X-GitLab-Pipeline-Refヘッダーが追加される | E-12 | ○ |
| C-10 | X-GitLab-Pipeline-Statusヘッダーが追加される | E-12 | ○ |
| C-11 | HTMLとテキストのマルチパート形式 | E-06, E-07 | ○ |
| C-12 | _successful_pipelineパーシャルを使用 | E-06, E-07 | ○ |
| C-13 | パイプライン名またはIDが表示される | E-08, E-09 | ○ |
| C-14 | コミットメッセージは50文字で切り詰められる | E-08, E-09 | ○ |
| C-15 | マージリクエスト情報は該当する場合のみ表示 | E-02, E-08 | ○ |
| C-16 | ジョブ数とステージ数が表示される | E-08, E-09 | ○ |
| C-17 | recipientがArrayの場合ArgumentError発生 | E-02 | ○ |
| C-18 | notifiable_usersで受信者を決定 | E-03 | ○ |
| C-19 | カスタムアクションfixed_pipelineを使用 | E-03 | ○ |
| C-20 | email_with_layoutメソッドでメール生成 | E-02, E-11 | ○ |
| C-21 | p_ci_pipelinesテーブルを参照 | E-10 | ○ |
| C-22 | パイプラインはパーティションテーブル | E-10 | ○ |
| C-23 | merge_requests_as_head_pipelineから最初のMRを取得 | E-02 | ○ |
| C-24 | レート制限はGitLabインスタンス設定による | **根拠なし** | △ |
| C-25 | Sidekiqリトライ回数は25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **レート制限値（C-24）**: 具体的な数値はインスタンス設定に依存し、コードからは特定できない
  - 候補: `config/gitlab.yml` / 管理画面設定 / 環境変数
- **Sidekiqリトライ回数（C-25）**: Sidekiqのデフォルト設定に依存
  - 候補: `config/sidekiq_queues.yml` / Sidekiq gem のデフォルト値

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メーラー実装は明確に確認できる
- 0: 低リスク - テンプレートファイルの存在と内容を確認済み
- 1: 中リスク - レート制限の運用設定は環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] pipeline_fixed_emailの実際のメール出力を確認（staging環境等）
- [ ] ref_status='fixed'の判定ロジックがCi::Refモデルと整合しているか確認
- [ ] レート制限の運用設定値を確認
- [ ] HTMLテンプレートのレイアウト崩れがないか確認
