---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：42-pipeline_schedule_owner_unavailable_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **スケジュール非アクティブ化のトリガー箇所**：具体的な呼び出し元の特定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/emails/pipeline_schedules.rb` 5-13行目 - pipeline_schedule_owner_unavailable_emailメソッド定義
- E-02: `app/services/notification_service.rb` 586-590行目 - pipeline_schedule_owner_unavailableメソッド
- E-03: `app/views/notify/pipeline_schedule_owner_unavailable_email.html.haml` - HTMLテンプレート
- E-04: `app/views/notify/pipeline_schedule_owner_unavailable_email.text.erb` - テキストテンプレート
- E-05: `app/models/ci/pipeline_schedule.rb` - パイプラインスケジュールモデル定義
- E-06: `app/mailers/emails/pipeline_schedules.rb` 17-19行目 - assign_new_owner_subjectメソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pipeline_schedule_owner_unavailable_emailメソッドが存在する | E-01 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | owners_and_maintainersで受信者を取得 | E-02 | ○ |
| C-04 | 件名形式が「Take ownership of the pipeline schedule: {説明}」 | E-01, E-06 | ○ |
| C-05 | @schedule変数が設定される | E-01 | ○ |
| C-06 | recipientがArrayの場合ArgumentError発生 | E-01 | ○ |
| C-07 | recipient.notification_email_or_defaultで送信先を取得 | E-01 | ○ |
| C-08 | スケジュール説明へのリンクが含まれる | E-03, E-04 | ○ |
| C-09 | ヘルプドキュメントへのリンクが含まれる | E-03, E-04 | ○ |
| C-10 | HTMLとテキストのマルチパート形式 | E-03, E-04 | ○ |
| C-11 | ci_pipeline_schedulesテーブルを参照 | E-05 | ○ |
| C-12 | descriptionカラムでスケジュール名を取得 | E-05 | ○ |
| C-13 | project_idでプロジェクトを参照 | E-05 | ○ |
| C-14 | owner_idでオーナーを参照 | E-05 | ○ |
| C-15 | activeカラムでアクティブ状態を管理 | E-05 | ○ |
| C-16 | email_with_layoutでメール生成 | E-01 | ○ |
| C-17 | project_pipeline_schedule_urlでスケジュールURLを生成 | E-03 | ○ |
| C-18 | スケジュール非アクティブ化のトリガー箇所 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **スケジュール非アクティブ化のトリガー（C-18）**: 具体的にどのサービスからpipeline_schedule_owner_unavailableが呼び出されるかの特定が必要
  - 候補: `app/services/ci/pipeline_schedules/` 配下のサービス / ワーカークラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メーラー実装は明確に確認できる
- 0: 低リスク - テンプレートファイルの存在と内容を確認済み
- 1: 中リスク - 通知のトリガー箇所の特定が必要

## 6) レビュアーチェックリスト（最小）
- [ ] pipeline_schedule_owner_unavailable_emailの実際のメール出力を確認
- [ ] 通知のトリガー箇所（呼び出し元）を特定
- [ ] owners_and_maintainersメソッドの動作確認（グループ継承含む）
- [ ] ヘルプドキュメントリンクの有効性確認
