---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：43-new_user_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パスワードリセットトークンの有効期限値**：具体的な値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/emails/profile.rb` 7-12行目 - new_user_emailメソッド定義
- E-02: `app/services/notification_service.rb` 461-466行目 - new_userメソッド
- E-03: `app/views/notify/new_user_email.html.haml` - HTMLテンプレート
- E-04: `app/views/notify/new_user_email.text.erb` - テキストテンプレート
- E-05: `app/models/user.rb` - ユーザーモデル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | new_user_emailメソッドが存在する | E-01 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | notifiable?で通知可能か確認 | E-02 | ○ |
| C-04 | OmniAuth経由の場合は送信しない | E-02 | ○ |
| C-05 | user.identities.any?でOmniAuth判定 | E-02 | ○ |
| C-06 | 件名が「Account was created for you」 | E-01 | ○ |
| C-07 | @user、@current_user変数が設定される | E-01 | ○ |
| C-08 | @target_urlにuser_url設定 | E-01 | ○ |
| C-09 | @tokenにパスワードリセットトークン設定 | E-01 | ○ |
| C-10 | HTMLとテキストのマルチパート形式 | E-03, E-04 | ○ |
| C-11 | セルフサインアップの場合と管理者作成で表示が異なる | E-03, E-04 | ○ |
| C-12 | Gitlab::CurrentSettings.allow_signup?で判定 | E-03 | ○ |
| C-13 | 管理者作成の場合パスワード設定リンクが含まれる | E-03, E-04 | ○ |
| C-14 | user.created_by_idで管理者作成を判定 | E-03, E-04 | ○ |
| C-15 | edit_password_urlでパスワード設定URL生成 | E-03, E-04 | ○ |
| C-16 | new_user_password_urlでリセットURL生成 | E-03, E-04 | ○ |
| C-17 | password_reset_token_valid_timeで有効期限表示 | E-03, E-04 | ○ |
| C-18 | notification_email_or_defaultで送信先取得 | E-01 | ○ |
| C-19 | User.findでユーザー情報取得 | E-01 | ○ |
| C-20 | email_with_layoutでメール生成 | E-01 | ○ |
| C-21 | usersテーブルを参照 | E-05 | ○ |
| C-22 | パスワードリセットトークンの具体的な有効期限 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **パスワードリセットトークンの有効期限（C-22）**: password_reset_token_valid_timeヘルパーの具体的な値は設定依存
  - 候補: `config/initializers/devise.rb` / `Devise.reset_password_within`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メーラー実装は明確に確認できる
- 0: 低リスク - テンプレートファイルの存在と内容を確認済み
- 1: 中リスク - パスワードリセットトークンの有効期限は環境依存

## 6) レビュアーチェックリスト（最小）
- [ ] new_user_emailの実際のメール出力を確認（セルフサインアップ/管理者作成両方）
- [ ] パスワードリセットトークンの有効期限設定を確認
- [ ] OmniAuth作成ユーザーに対してメールが送信されないことを確認
- [ ] パスワード設定リンクの有効性確認
