---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：44-instance_access_request_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **承認者選定ロジックの詳細**：具体的な選定条件の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/emails/profile.rb` 14-21行目 - instance_access_request_emailメソッド定義
- E-02: `app/services/notification_service.rb` 495-503行目 - new_instance_access_requestメソッド
- E-03: `app/views/notify/instance_access_request_email.html.haml` - HTMLテンプレート
- E-04: `app/views/notify/instance_access_request_email.text.erb` - テキストテンプレート
- E-05: `app/models/user.rb` 51行目 - INSTANCE_ACCESS_REQUEST_APPROVERS_TO_BE_NOTIFIED_LIMIT定数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | instance_access_request_emailメソッドが存在する | E-01 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | instance_access_request_approvers_to_be_notifiedで承認者取得 | E-02 | ○ |
| C-04 | 最大10人の承認者に通知 | E-05 | ○ |
| C-05 | 承認者が空の場合は早期リターン | E-02 | ○ |
| C-06 | 件名が「GitLab Account Request」 | E-01 | ○ |
| C-07 | @userと@recipient変数が設定される | E-01 | ○ |
| C-08 | HTMLとテキストのマルチパート形式 | E-03, E-04 | ○ |
| C-09 | ユーザー名とメールアドレスが含まれる | E-03, E-04 | ○ |
| C-10 | say_helloヘルパーで挨拶を表示 | E-04 | ○ |
| C-11 | instance_access_request_textで本文生成 | E-04 | ○ |
| C-12 | instance_access_request_linkで管理画面リンク生成 | E-04 | ○ |
| C-13 | notification_email_or_defaultで送信先取得 | E-01 | ○ |
| C-14 | email_with_layoutでメール生成 | E-01 | ○ |
| C-15 | usersテーブルを参照 | E-05 | ○ |
| C-16 | 各承認者にループでメール送信 | E-02 | ○ |
| C-17 | INSTANCE_ACCESS_REQUEST_APPROVERS_TO_BE_NOTIFIED_LIMIT = 10 | E-05 | ○ |
| C-18 | 承認者選定ロジックの詳細条件 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **承認者選定ロジックの詳細（C-18）**: instance_access_request_approvers_to_be_notifiedメソッドの具体的な実装詳細
  - 候補: `app/models/user.rb` / `app/models/concerns/` 配下

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メーラー実装は明確に確認できる
- 0: 低リスク - テンプレートファイルの存在と内容を確認済み
- 1: 中リスク - 承認者選定ロジックの完全な理解が必要

## 6) レビュアーチェックリスト（最小）
- [ ] instance_access_request_emailの実際のメール出力を確認
- [ ] instance_access_request_approvers_to_be_notifiedの選定ロジックを確認
- [ ] 承認者が10人を超える場合の動作を確認
- [ ] 管理画面リンクの有効性確認
