---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-new_ssh_key_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目の根拠が確認できた）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/emails/profile.rb` 41-50行目 - new_ssh_key_emailメソッド定義
- E-02: `app/services/notification_service.rb` 84-88行目 - new_keyメソッド
- E-03: `app/views/notify/new_ssh_key_email.html.haml` - HTMLテンプレート
- E-04: `app/views/notify/new_ssh_key_email.text.erb` - テキストテンプレート
- E-05: `app/models/key.rb` - Keyモデル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | new_ssh_key_emailメソッドが存在する | E-01 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | key.user&.can?(:receive_notifications)で通知可能判定 | E-02 | ○ |
| C-04 | 件名が「SSH key was added to your account」 | E-01 | ○ |
| C-05 | Key.find_by(id: key_id)でキー取得 | E-01 | ○ |
| C-06 | キーが存在しない場合は早期リターン | E-01 | ○ |
| C-07 | @key、@user、@current_user、@target_url変数が設定される | E-01 | ○ |
| C-08 | HTMLとテキストのマルチパート形式 | E-03, E-04 | ○ |
| C-09 | キータイトルが表示される | E-03, E-04 | ○ |
| C-10 | user_settings_ssh_keys_urlで削除リンクを生成 | E-03, E-04 | ○ |
| C-11 | email_with_layoutでメール生成 | E-01 | ○ |
| C-12 | notification_email_or_defaultで送信先取得 | E-01 | ○ |
| C-13 | keysテーブルを参照 | E-05 | ○ |
| C-14 | user_idでユーザーを参照 | E-05 | ○ |
| C-15 | titleカラムでキータイトルを取得 | E-05 | ○ |
| C-16 | sanitize_nameでユーザー名をサニタイズ | E-03, E-04 | ○ |
| C-17 | 翻訳対応（s_()関数使用） | E-03 | ○ |
| C-18 | link_toでSSHキー設定へのリンク生成 | E-03 | ○ |
| C-19 | content_tagでキータイトルをcode要素で囲む | E-03 | ○ |
| C-20 | after_create :post_create_hookコールバック | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メーラー実装は明確に確認できる
- 0: 低リスク - テンプレートファイルの存在と内容を確認済み
- 0: 低リスク - セキュリティ通知として適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] new_ssh_key_emailの実際のメール出力を確認
- [ ] デプロイキー追加時に通知が送信されないことを確認
- [ ] 内部ユーザー（ゴーストユーザー等）に通知が送信されないことを確認
- [ ] SSHキー設定リンクの有効性確認
