---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：49-bot_resource_access_token_about_to_expire_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **バッチ処理の呼び出し元**：具体的なワーカークラスの特定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/emails/profile.rb` 67-90行目 - bot_resource_access_token_about_to_expire_emailメソッド定義
- E-02: `app/services/notification_service.rb` 100-115行目 - bot_resource_access_token_about_to_expireメソッド
- E-03: `app/services/notification_service.rb` 982-994行目 - bot_resource_access_token_about_to_expire_recipientsメソッド
- E-04: `app/views/notify/bot_resource_access_token_about_to_expire_email.html.haml` - HTMLテンプレート
- E-05: `app/views/notify/bot_resource_access_token_about_to_expire_email.text.erb` - テキストテンプレート
- E-06: `app/models/personal_access_token.rb` - PersonalAccessTokenモデル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bot_resource_access_token_about_to_expire_emailメソッドが存在する | E-01 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | bot_user.resource_bot_resourceでリソース取得 | E-02 | ○ |
| C-04 | recipient.can?(:receive_notifications)で通知可能判定 | E-02 | ○ |
| C-05 | 継承設定に応じて受信者を決定 | E-03 | ○ |
| C-06 | inherited_rat_members_relationで親グループメンバー取得 | E-03 | ○ |
| C-07 | resource_bot_owners_and_maintainersで直接メンバー取得 | E-03 | ○ |
| C-08 | 件名に残り日数が含まれる | E-01 | ○ |
| C-09 | @user、@token_name、@days_to_expire変数が設定される | E-01 | ○ |
| C-10 | @resource変数にプロジェクトまたはグループが設定される | E-01, E-02 | ○ |
| C-11 | リソースタイプに応じて@target_urlが異なる | E-01 | ○ |
| C-12 | リソースタイプに応じて@reason_textが異なる | E-01 | ○ |
| C-13 | HTMLとテキストのマルチパート形式 | E-04, E-05 | ○ |
| C-14 | トークン名とリソースパスが表示される | E-04, E-05 | ○ |
| C-15 | アクセストークン設定へのリンクが含まれる | E-04, E-05 | ○ |
| C-16 | email_with_layoutでメール生成 | E-01 | ○ |
| C-17 | notification_email_or_defaultで送信先取得 | E-01 | ○ |
| C-18 | DAYS_TO_EXPIREはデフォルト7日 | E-06 | ○ |
| C-19 | safe_formatヘルパーで件名生成 | E-01 | ○ |
| C-20 | pluralizeで日数の単数形/複数形を処理 | E-01, E-04, E-05 | ○ |
| C-21 | resource.full_pathでリソースパス取得 | E-04, E-05 | ○ |
| C-22 | tag_pair/code_tag_pairでコードタグ生成 | E-04 | ○ |
| C-23 | log_infoでログ記録 | E-02 | ○ |
| C-24 | バッチ処理の具体的な呼び出し元 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **バッチ処理の呼び出し元（C-24）**: 具体的なワーカークラスの特定が必要
  - 候補: `app/workers/` 配下 / `lib/gitlab/background_migration/` 配下

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メーラー実装は明確に確認できる
- 0: 低リスク - テンプレートファイルの存在と内容を確認済み
- 1: 中リスク - バッチ処理のトリガー箇所の完全な理解が必要

## 6) レビュアーチェックリスト（最小）
- [ ] bot_resource_access_token_about_to_expire_emailの実際のメール出力を確認
- [ ] プロジェクトとグループ両方のケースでメール内容を確認
- [ ] 継承設定の動作確認（親グループOwnerへの通知）
- [ ] バッチ処理の実行タイミングとワーカーを特定
