---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-access_token_created_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目の根拠が確認できた）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/emails/profile.rb` 92-103行目 - access_token_created_emailメソッド定義
- E-02: `app/services/notification_service.rb` 118-122行目 - access_token_createdメソッド
- E-03: `app/views/notify/access_token_created_email.html.haml` - HTMLテンプレート
- E-04: `app/views/notify/access_token_created_email.text.erb` - テキストテンプレート
- E-05: `app/models/personal_access_token.rb` - PersonalAccessTokenモデル定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | access_token_created_emailメソッドが存在する | E-01 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | user.can?(:receive_notifications)で通知可能判定 | E-02 | ○ |
| C-04 | user&.active?でアクティブ判定 | E-01 | ○ |
| C-05 | 件名が「A new personal access token has been created」 | E-01 | ○ |
| C-06 | @user、@token_name、@target_url変数が設定される | E-01 | ○ |
| C-07 | user_settings_personal_access_tokens_urlで設定URL生成 | E-01 | ○ |
| C-08 | HTMLとテキストのマルチパート形式 | E-03, E-04 | ○ |
| C-09 | トークン名が表示される | E-03, E-04 | ○ |
| C-10 | 個人アクセストークン設定へのリンクが含まれる | E-03, E-04 | ○ |
| C-11 | email_with_layoutでメール生成 | E-01 | ○ |
| C-12 | notification_email_or_defaultで送信先取得 | E-01 | ○ |
| C-13 | 非アクティブユーザーの場合は早期リターン | E-01 | ○ |
| C-14 | sanitize_nameでユーザー名をサニタイズ | E-03, E-04 | ○ |
| C-15 | 翻訳対応（_()関数使用） | E-03, E-04 | ○ |
| C-16 | html_escapeでXSS対策 | E-03 | ○ |
| C-17 | code要素でトークン名を囲む | E-03 | ○ |
| C-18 | personal_access_tokensテーブルが存在 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メーラー実装は明確に確認できる
- 0: 低リスク - テンプレートファイルの存在と内容を確認済み
- 0: 低リスク - セキュリティ通知として適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] access_token_created_emailの実際のメール出力を確認
- [ ] 非アクティブユーザーにメールが送信されないことを確認
- [ ] 個人アクセストークン設定リンクの有効性確認
- [ ] トークン名の表示が適切かを確認（長い名前の場合等）
