---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：51-access_token_about_to_expire_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **レート制限の詳細仕様**：GitLab設定依存のため具体値不明
  2. **Cronジョブ実行スケジュール**：具体的な実行時刻はインフラ設定に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/personal_access_tokens/expiring_worker.rb` (27-96行目)
- E-02: `app/services/notification_service.rb` (126-132行目)
- E-03: `app/mailers/emails/profile.rb` (105-123行目)
- E-04: `app/views/notify/access_token_about_to_expire_email.text.erb` (1-9行目)
- E-05: `app/mailers/previews/notify_preview.rb` (111-113行目)
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` (51行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はaccess_token_about_to_expire_email | E-03, E-06 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | 有効期限7日以内で通知 | E-01 | ○ |
| C-04 | PersonalAccessTokens::ExpiringWorkerがトリガー | E-01 | ○ |
| C-05 | NotificationServiceを経由 | E-02 | ○ |
| C-06 | Emails::Profileモジュールでメール生成 | E-03 | ○ |
| C-07 | テキスト形式メール | E-04 | ○ |
| C-08 | 件名にdays_to_expireを含む | E-03 | ○ |
| C-09 | @token_namesでトークン名配列を渡す | E-03, E-04 | ○ |
| C-10 | @target_urlでPAT設定画面リンク | E-03 | ○ |
| C-11 | user.can?(:receive_notifications)チェック | E-02 | ○ |
| C-12 | MAX_TOKENS = 100 | E-01 | ○ |
| C-13 | MAX_RUNTIME = 3分 | E-01 | ○ |
| C-14 | REQUEUE_DELAY = 2分 | E-01 | ○ |
| C-15 | notification_intervalsでループ | E-01 | ○ |
| C-16 | process_user_tokensで処理 | E-01 | ○ |
| C-17 | interval_notification_sent_atを更新 | E-01 | ○ |
| C-18 | ユーザーのnotification_email_or_defaultに送信 | E-03 | ○ |
| C-19 | NOTIFICATION_INTERVALSに7日を含む | E-01 | ○ |
| C-20 | scope_for_notification_intervalでトークン取得 | E-01 | ○ |
| C-21 | deliver_user_notificationsで通知実行 | E-01 | ○ |
| C-22 | days_to_expire: パラメータ対応 | E-01, E-03 | ○ |
| C-23 | プレビュー機能あり | E-05 | ○ |
| C-24 | レート制限はGitLab設定に依存 | **根拠なし** | △ |
| C-25 | Cronジョブは毎日実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レート制限の具体的な設定値
  - 候補：GitLab設定ファイル / Railsコンフィグ / インフラ設定
- Cronジョブの実行スケジュール詳細
  - 候補：config/initializers/cronjobs.rb / Kubernetes CronJob設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は全てコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ExpiringWorkerのperformメソッドが設計書と一致するか確認
- [ ] メールテンプレートの変数が正しく設定されているか確認
- [ ] 通知間隔（7日）の妥当性をビジネス要件と照合
