---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：52-access_token_expired_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Cronジョブ実行タイミング**：具体的な実行時刻はインフラ設定に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/personal_access_tokens/expired_notification_worker.rb` (全体)
- E-02: `app/services/notification_service.rb` (135-139行目)
- E-03: `app/mailers/emails/profile.rb` (125-136行目)
- E-04: `app/views/notify/access_token_expired_email.text.erb` (全体)
- E-05: `app/mailers/previews/notify_preview.rb` (102-105行目)
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` (52行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はaccess_token_expired_email | E-03, E-06 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | ExpiredNotificationWorkerがトリガー | E-01 | ○ |
| C-04 | 当日期限切れトークンが対象 | E-01 | ○ |
| C-05 | with_personal_access_tokens_expired_todayスコープ使用 | E-01 | ○ |
| C-06 | expired_today_and_not_notifiedスコープ使用 | E-01 | ○ |
| C-07 | MAX_TOKENS = 100 | E-01 | ○ |
| C-08 | 件名「Your personal access tokens have expired」 | E-03 | ○ |
| C-09 | user.active?チェック | E-03 | ○ |
| C-10 | @token_names配列（空可） | E-03, E-04 | ○ |
| C-11 | トークン名なしの場合の汎用メッセージ | E-04 | ○ |
| C-12 | after_expiry_notification_deliveredフラグ更新 | E-01 | ○ |
| C-13 | find_eachでバッチ処理 | E-01 | ○ |
| C-14 | NotificationServiceを経由 | E-02 | ○ |
| C-15 | Emails::Profileモジュールでメール生成 | E-03 | ○ |
| C-16 | テキスト形式メール | E-04 | ○ |
| C-17 | @target_urlでPAT設定画面リンク | E-03 | ○ |
| C-18 | user.can?(:receive_notifications)チェック | E-02 | ○ |
| C-19 | プレビュー機能あり | E-05 | ○ |
| C-20 | Cronジョブは毎日実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronジョブの実行スケジュール詳細
  - 候補：config/initializers/cronjobs.rb / Kubernetes CronJob設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は全てコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ExpiredNotificationWorkerのperformメソッドが設計書と一致するか確認
- [ ] テンプレートの条件分岐（トークン名有無）が正しいか確認
