---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-access_token_rotated_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` (149-153行目)
- E-02: `app/mailers/emails/profile.rb` (152-163行目)
- E-03: `app/views/notify/access_token_rotated_email.text.erb` (全体)
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` (54行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はaccess_token_rotated_email | E-02, E-04 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-01 | ○ |
| C-03 | NotificationService#access_token_rotatedがエントリー | E-01 | ○ |
| C-04 | user.can?(:receive_notifications)チェック | E-01 | ○ |
| C-05 | user.active?チェック | E-02 | ○ |
| C-06 | 件名「Your personal access token has been rotated」 | E-02 | ○ |
| C-07 | @token_nameでローテーショントークン名を渡す | E-02, E-03 | ○ |
| C-08 | @target_urlでPAT設定画面リンク | E-02 | ○ |
| C-09 | Emails::Profileモジュールでメール生成 | E-02 | ○ |
| C-10 | テキスト形式メール | E-03 | ○ |
| C-11 | ユーザーのnotification_email_or_defaultに送信 | E-02 | ○ |
| C-12 | イベント発生時に即座に送信 | E-01 | ○ |
| C-13 | トークン名のみを通知に含む | E-03 | ○ |
| C-14 | 新トークン値はメールに含まれない | E-03 | ○ |
| C-15 | 設定画面で確認を促すメッセージ | E-03 | ○ |
| C-16 | ローテーション完了後に通知 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ローテーション処理との連携が正しく記述されているか確認
- [ ] テンプレートの内容が適切か確認
