---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：55-deploy_token_about_to_expire_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Cronジョブ実行スケジュール**：具体的な実行時刻はインフラ設定に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/deploy_tokens/expiring_worker.rb` (全体)
- E-02: `app/services/notification_service.rb` (156-163行目)
- E-03: `app/mailers/emails/profile.rb` (165-183行目)
- E-04: `app/views/notify/deploy_token_about_to_expire_email.text.erb` (全体)
- E-05: `app/mailers/previews/notify_preview.rb` (115-117行目)
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` (55行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はdeploy_token_about_to_expire_email | E-03, E-06 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | DeployTokens::ExpiringWorkerがトリガー | E-01 | ○ |
| C-04 | Owner/Maintainerに通知 | E-01, E-02 | ○ |
| C-05 | user.can?(:receive_notifications)チェック | E-02 | ○ |
| C-06 | プロジェクトのOwner/Maintainerチェック | E-02 | ○ |
| C-07 | 件名に残り日数を含む | E-03 | ○ |
| C-08 | @token_nameでトークン名を渡す | E-03, E-04 | ○ |
| C-09 | @projectでプロジェクトを渡す | E-03 | ○ |
| C-10 | @days_to_expireで残り日数を渡す | E-03, E-04 | ○ |
| C-11 | @target_urlでデプロイトークン設定画面リンク | E-03 | ○ |
| C-12 | @user_roleでOwner/Maintainerを表示 | E-03, E-04 | ○ |
| C-13 | Feature.enabled?チェック | E-01 | ○ |
| C-14 | BATCH_SIZE = 100 | E-01 | ○ |
| C-15 | MAX_RUNTIME = 3分 | E-01 | ○ |
| C-16 | REQUEUE_DELAY = 2分 | E-01 | ○ |
| C-17 | notification_intervalsでループ | E-01 | ○ |
| C-18 | process_deploy_tokensで処理 | E-01 | ○ |
| C-19 | update_notification_timestampsで更新 | E-01 | ○ |
| C-20 | テキスト形式メール | E-04 | ○ |
| C-21 | プレビュー機能あり | E-05 | ○ |
| C-22 | Cronジョブは毎日実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronジョブの実行スケジュール詳細
  - 候補：config/initializers/cronjobs.rb / Kubernetes CronJob設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は全てコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ExpiringWorkerのperformメソッドが設計書と一致するか確認
- [ ] Feature.enabled?の対象フラグ名が正しいか確認
- [ ] Owner/Maintainer判定ロジックが正しいか確認
