---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：56-ssh_key_expired_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Cronジョブ実行スケジュール**：具体的な実行時刻はインフラ設定に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/keys/expiry_notification_service.rb` (全体)
- E-02: `app/services/notification_service.rb` (166-170行目)
- E-03: `app/mailers/emails/profile.rb` (185-193行目)
- E-04: `app/views/notify/ssh_key_expired_email.text.erb` (全体)
- E-05: `app/mailers/previews/notify_preview.rb` (119-122行目)
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` (56行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はssh_key_expired_email | E-03, E-06 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | Keys::ExpiryNotificationServiceを経由 | E-01 | ○ |
| C-04 | user.can?(:receive_notifications)チェック | E-01 | ○ |
| C-05 | user.active?チェック | E-03 | ○ |
| C-06 | 件名「Your SSH key has expired」 | E-03 | ○ |
| C-07 | @fingerprintsでフィンガープリント配列を渡す | E-03, E-04 | ○ |
| C-08 | @target_urlでSSHキー設定画面リンク | E-03 | ○ |
| C-09 | trigger_expired_notificationで通知実行 | E-01 | ○ |
| C-10 | expiry_notification_delivered_atを更新 | E-01 | ○ |
| C-11 | Todo作成（TodoService.ssh_key_expired） | E-01 | ○ |
| C-12 | Emails::Profileモジュールでメール生成 | E-03 | ○ |
| C-13 | テキスト形式メール | E-04 | ○ |
| C-14 | ユーザーのnotification_email_or_defaultに送信 | E-03 | ○ |
| C-15 | フィンガープリントのみを通知に含む | E-04 | ○ |
| C-16 | プレビュー機能あり | E-05 | ○ |
| C-17 | NotificationService#ssh_key_expiredがエントリー | E-02 | ○ |
| C-18 | Cronジョブは毎日実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronジョブの実行スケジュール詳細
  - 候補：config/initializers/cronjobs.rb / Kubernetes CronJob設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は全てコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ExpiryNotificationServiceのexecuteメソッドが設計書と一致するか確認
- [ ] Todo作成との連携が正しく記述されているか確認
