---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：57-ssh_key_expiring_soon_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Cronジョブ実行スケジュール**：具体的な実行時刻はインフラ設定に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `app/workers/ssh_keys/expiring_soon_notification_worker.rb` (全体)
- E-02: `app/services/keys/expiry_notification_service.rb` (32-36行目)
- E-03: `app/services/notification_service.rb` (173-177行目)
- E-04: `app/mailers/emails/profile.rb` (195-203行目)
- E-05: `app/views/notify/ssh_key_expiring_soon.text.erb` (全体)
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` (57行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はssh_key_expiring_soon_email | E-04, E-06 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-03 | ○ |
| C-03 | ExpiringSoonNotificationWorkerがトリガー | E-01 | ○ |
| C-04 | User.with_ssh_key_expiring_soonでユーザー取得 | E-01 | ○ |
| C-05 | expiring_soon_and_unnotified_keysでキー取得 | E-01 | ○ |
| C-06 | user.can?(:receive_notifications)チェック | E-02 | ○ |
| C-07 | user.active?チェック | E-04 | ○ |
| C-08 | 件名「Your SSH key expires soon」 | E-04 | ○ |
| C-09 | @fingerprintsでフィンガープリント配列を渡す | E-04, E-05 | ○ |
| C-10 | @target_urlでSSHキー設定画面リンク | E-04 | ○ |
| C-11 | trigger_expiring_soon_notificationで通知実行 | E-02 | ○ |
| C-12 | before_expiry_notification_delivered_atを更新 | E-02 | ○ |
| C-13 | Todo作成（TodoService.ssh_key_expiring_soon） | E-02 | ○ |
| C-14 | mail_with_localeを使用 | E-04 | ○ |
| C-15 | batch_size: 10_000 | E-01 | ○ |
| C-16 | Emails::Profileモジュールでメール生成 | E-04 | ○ |
| C-17 | テキスト形式メール | E-05 | ○ |
| C-18 | フィンガープリントのみを通知に含む | E-05 | ○ |
| C-19 | Keys::ExpiryNotificationServiceを経由 | E-01, E-02 | ○ |
| C-20 | Cronジョブは毎日実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Cronジョブの実行スケジュール詳細
  - 候補：config/initializers/cronjobs.rb / Kubernetes CronJob設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は全てコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ExpiringSoonNotificationWorkerのperformメソッドが設計書と一致するか確認
- [ ] ExpiryNotificationServiceとの連携が正しく記述されているか確認
- [ ] mail_with_locale使用の理由を確認
