---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-unknown_sign_in_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/concerns/known_sign_in.rb` (全体)
- E-02: `app/services/notification_service.rb` (181-185行目)
- E-03: `app/mailers/emails/profile.rb` (205-216行目)
- E-04: `app/mailers/previews/notify_preview.rb` (273-275行目)
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` (58行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はunknown_sign_in_email | E-03, E-05 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | KnownSignIn concernがトリガー | E-01 | ○ |
| C-04 | verify_known_sign_inでチェック | E-01 | ○ |
| C-05 | Gitlab::CurrentSettings.notify_on_unknown_sign_in?チェック | E-01 | ○ |
| C-06 | known_device?でCookie確認 | E-01 | ○ |
| C-07 | known_remote_ip?でIP確認 | E-01 | ○ |
| C-08 | KNOWN_SIGN_IN_COOKIE_EXPIRY = 14日 | E-01 | ○ |
| C-09 | user.can?(:receive_notifications)チェック | E-02 | ○ |
| C-10 | 件名に{host}を含む | E-03 | ○ |
| C-11 | @ipでIPアドレスを渡す | E-03 | ○ |
| C-12 | @cityで都市名を渡す | E-03 | ○ |
| C-13 | @countryで国名を渡す | E-03 | ○ |
| C-14 | @timeでサインイン日時を渡す | E-03 | ○ |
| C-15 | @target_urlでパスワード変更URLを渡す | E-03 | ○ |
| C-16 | Gitlab::Auth::VisitorLocationで位置情報取得 | E-01 | ○ |
| C-17 | notify_userでNotificationService呼び出し | E-01 | ○ |
| C-18 | Emails::Profileモジュールでメール生成 | E-03 | ○ |
| C-19 | email_with_layoutを使用 | E-03 | ○ |
| C-20 | ActiveSessionからIP取得 | E-01 | ○ |
| C-21 | last_sign_in_ipで過去IP確認 | E-01 | ○ |
| C-22 | プレビュー機能あり | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] KnownSignIn concernの処理フローが設計書と一致するか確認
- [ ] 位置情報取得の仕組みが正しく記述されているか確認
- [ ] セキュリティ通知としての重要性が適切に記述されているか確認
