---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-two_factor_otp_attempt_failed_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/concerns/authenticates_with_two_factor.rb` (106-118行目, 256-258行目)
- E-02: `app/services/notification_service.rb` (189-193行目)
- E-03: `app/mailers/emails/profile.rb` (218-231行目)
- E-04: `app/mailers/previews/notify_preview.rb` (277-279行目)
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` (59行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はtwo_factor_otp_attempt_failed_email | E-03, E-05 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-02 | ○ |
| C-03 | AuthenticatesWithTwoFactor concernがトリガー | E-01 | ○ |
| C-04 | authenticate_with_two_factor_via_otpで呼び出し | E-01 | ○ |
| C-05 | valid_otp_attempt?失敗時に送信 | E-01 | ○ |
| C-06 | send_two_factor_otp_attempt_failed_emailで通知 | E-01 | ○ |
| C-07 | user.can?(:receive_notifications)チェック | E-02 | ○ |
| C-08 | 件名にホスト名を含む | E-03 | ○ |
| C-09 | @userで対象ユーザーを渡す | E-03 | ○ |
| C-10 | @ipでIPアドレスを渡す | E-03 | ○ |
| C-11 | @timeで日時を渡す | E-03 | ○ |
| C-12 | Time.currentをデフォルト値として使用 | E-03 | ○ |
| C-13 | Gitlab.config.gitlab.hostを件名に使用 | E-03 | ○ |
| C-14 | Emails::Profileモジュールでメール生成 | E-03 | ○ |
| C-15 | email_with_layoutを使用 | E-03 | ○ |
| C-16 | WebAuthn失敗時は送信されない | E-01 | ○ |
| C-17 | 認証失敗後にfailed_attempts増加 | E-01 | ○ |
| C-18 | プレビュー機能あり | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目がコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] authenticate_with_two_factor_via_otpの処理フローが設計書と一致するか確認
- [ ] OTP失敗のみで送信される点が正しく記述されているか確認
- [ ] セキュリティ通知としての重要性が適切に記述されているか確認
