---
generated_at: 2026-01-22 14:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-relabeled_issue_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` - relabeled_issueメソッド（269-271行目）、relabeled_resource_email（847-860行目）
- E-02: `app/mailers/emails/issues.rb` - relabeled_issue_emailメソッド（71-89行目）
- E-03: `app/views/notify/_relabeled_issuable_email.html.haml` - 共通テンプレート（全3行）
- E-04: `app/mailers/notify.rb` - mail_answer_thread（188-196行目）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | relabeled_issue_emailはラベル変更通知を送信 | E-01, E-02 | ○ |
| C-02 | NotificationService.relabeled_issue()がエントリーポイント | E-01 (269行目) | ○ |
| C-03 | relabeled_resource_emailを呼び出し | E-01 (270行目) | ○ |
| C-04 | 非同期送信（deliver_later）を使用 | E-01 (858行目) | ○ |
| C-05 | labels.flat_map { |l| l.subscribers(project) }で購読者取得 | E-01 (848行目) | ○ |
| C-06 | notifiable_usersでフィルタリング | E-01 (849-853行目) | ○ |
| C-07 | :subscriptionレベルで通知 | E-01 (850行目) | ○ |
| C-08 | label_names = labels.map(&:name)で名前リスト取得 | E-01 (855行目) | ○ |
| C-09 | setup_issue_mailでインスタンス変数設定 | E-02 (72行目) | ○ |
| C-10 | @label_names設定 | E-02 (74行目) | ○ |
| C-11 | @labels_url設定（プロジェクト/グループ分岐） | E-02 (75-78行目) | ○ |
| C-12 | mail_answer_threadでスレッド返信形式 | E-02 (80-88行目), E-04 | ○ |
| C-13 | テンプレートでn_関数使用 | E-03 (2行目) | ○ |
| C-14 | to_sentenceでカンマ区切りリスト | E-03 (2行目) | ○ |
| C-15 | X-GitLab-ConfidentialIssueヘッダー設定 | E-02 (issue_thread_options) | ○ |
| C-16 | 件名にRe:プレフィックス付与 | E-04 (193行目) | ○ |
| C-17 | SentNotification.recordで送信記録作成 | E-02 (setup_issue_mail内) | ○ |
| C-18 | acting_userで実行者除外 | E-01 (852行目) | ○ |
| C-19 | subscribed: trueパラメータでURL生成 | E-02 (76, 78行目) | ○ |
| C-20 | ラベル削除時は通知なし（追加時のみ） | E-01 (設計上) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信処理の基本フロー
- 0: 低リスク - 購読者取得ロジック
- 0: 低リスク - テンプレート表示ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] label.subscribersメソッドの動作確認
- [ ] 複数ラベル追加時のメッセージ表示確認
- [ ] @labels_urlがプロジェクト/グループで正しく分岐するか確認
- [ ] ラベル変更実行者が通知対象から除外されているか確認
