---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：61-enabled_two_factor_webauthn_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/emails/profile.rb` 行244-256
- E-02: `app/services/notification_service.rb` 行49-60
- E-03: `app/controllers/profiles/two_factor_auths_controller.rb` 行56-89, 303-305
- E-04: `app/services/authn/passkey/register_service.rb` 行59-60
- E-05: `app/views/notify/enabled_two_factor_webauthn_email.html.haml` 全体
- E-06: `app/views/notify/enabled_two_factor_webauthn_email.text.erb` 全体
- E-07: `app/mailers/application_mailer.rb` 行21-22, 63-67
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行62

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は enabled_two_factor_webauthn_email | E-01, E-08 | ○ |
| C-02 | WebAuthnデバイスまたはパスキー登録時に送信される | E-02, E-03, E-04 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02 行54, 56 | ○ |
| C-04 | ユーザーの通知受信可否をチェック | E-02 行50 | ○ |
| C-05 | 件名は「WebAuthn device registered」または「Passkey registered」 | E-01 行253-254 | ○ |
| C-06 | 送信元はGitlab.config.gitlab.email_from | E-07 行21, 63-67 | ○ |
| C-07 | @user, @device_name, @typeがテンプレート変数 | E-01 行247-249 | ○ |
| C-08 | type引数でwebauthnとpasskeyを区別 | E-01 行244, E-02 行52-56 | ○ |
| C-09 | テンプレートはHTMLとテキストの両方を提供 | E-05, E-06 | ○ |
| C-10 | WebAuthnの場合は二要素認証管理リンクを含む | E-05 行7 | ○ |
| C-11 | パスキーの場合はヘルプページリンクを含む | E-05 行12-13 | ○ |
| C-12 | TwoFactorAuthsController#create_webauthnがエントリーポイント | E-03 行55-89 | ○ |
| C-13 | RegisterServiceがパスキー登録のエントリーポイント | E-04 | ○ |
| C-14 | notify_on_successで通知を呼び出し | E-03 行68, 303-305, E-04 行59-60 | ○ |
| C-15 | セキュリティ通知のためレート制限なし | E-02（rate_limit_scope参照なし） | ○ |
| C-16 | 内部ユーザー・ゴーストユーザーには送信しない | E-02 行50 `can?(:receive_notifications)` | ○ |
| C-17 | Emails::Profileモジュールで定義 | E-01 行3-4 | ○ |
| C-18 | email_with_layoutでメール生成 | E-01 行251-255 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認：`_("WebAuthn device registered")`等の翻訳キーが適切か
- [ ] デバイス名のサニタイズ処理（`sanitize_name`）の実装を確認
- [ ] can?(:receive_notifications)の権限チェックロジックが適切か確認
