---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-disabled_two_factor_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/profile.rb` 行258-267
- E-02: `app/services/notification_service.rb` 行62-75
- E-03: `app/services/two_factor/destroy_service.rb` 全体
- E-04: `app/views/notify/disabled_two_factor_email.html.haml` 全体
- E-05: `app/views/notify/disabled_two_factor_email.text.erb` 全体
- E-06: `app/controllers/profiles/two_factor_auths_controller.rb` 行99-109
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行63

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は disabled_two_factor_email | E-01, E-07 | ○ |
| C-02 | 二要素認証が完全に無効化された際に送信 | E-03 行28-29, E-02 行73 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02 行73 | ○ |
| C-04 | ユーザーの通知受信可否をチェック | E-02 行63 | ○ |
| C-05 | 件名は「Two-factor authentication disabled」 | E-01 行265 | ○ |
| C-06 | @userがテンプレート変数 | E-01 行261 | ○ |
| C-07 | テンプレートはHTMLとテキストの両方を提供 | E-04, E-05 | ○ |
| C-08 | TwoFactor::DestroyServiceがエントリーポイント | E-03 | ○ |
| C-09 | notify_on_successで通知を呼び出し | E-03 行28-29 | ○ |
| C-10 | disabled_two_factor(user)で呼び出し | E-03 行29 | ○ |
| C-11 | 内部ユーザー・ゴーストユーザーには送信しない | E-02 行63 `can?(:receive_notifications)` | ○ |
| C-12 | Emails::Profileモジュールで定義 | E-01 行3-4 | ○ |
| C-13 | email_with_layoutでメール生成 | E-01 行263-266 | ○ |
| C-14 | say_hiヘルパーでユーザー挨拶 | E-04 行2 | ○ |
| C-15 | 二要素認証設定ページへのリンクを含む | E-04 行6 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認
- [ ] can?(:receive_notifications)の権限チェックロジックが適切か確認
- [ ] two_factor_authentication_disabled_textヘルパーの実装を確認
