---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-disabled_two_factor_otp_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/profile.rb` 行269-278
- E-02: `app/services/notification_service.rb` 行62-75
- E-03: `app/services/two_factor/destroy_otp_service.rb` 全体
- E-04: `app/views/notify/disabled_two_factor_otp_email.html.haml` 全体
- E-05: `app/views/notify/disabled_two_factor_otp_email.text.erb` 全体
- E-06: `app/controllers/profiles/two_factor_auths_controller.rb` 行111-121
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行64

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は disabled_two_factor_otp_email | E-01, E-07 | ○ |
| C-02 | OTP認証が削除された際に送信 | E-03 行36-38, E-02 行70-71 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02 行71 | ○ |
| C-04 | ユーザーの通知受信可否をチェック | E-02 行63 | ○ |
| C-05 | 件名は「One-time password authenticator deleted」 | E-01 行276 | ○ |
| C-06 | @userがテンプレート変数 | E-01 行272 | ○ |
| C-07 | テンプレートはHTMLとテキストの両方を提供 | E-04, E-05 | ○ |
| C-08 | TwoFactor::DestroyOtpServiceがエントリーポイント | E-03 | ○ |
| C-09 | notify_on_successで通知を呼び出し | E-03 行36-38 | ○ |
| C-10 | disabled_two_factor(user, :otp)で呼び出し | E-03 行37 | ○ |
| C-11 | 他の2FAがない場合はバックアップコードリセット | E-03 行17-19 | ○ |
| C-12 | 他の2FAがない場合はdisabled_two_factor_emailも送信 | E-03 行19 | ○ |
| C-13 | 内部ユーザー・ゴーストユーザーには送信しない | E-02 行63 | ○ |
| C-14 | Emails::Profileモジュールで定義 | E-01 行3-4 | ○ |
| C-15 | email_with_layoutでメール生成 | E-01 行274-277 | ○ |
| C-16 | OTPの説明テキストを含む | E-04 行4 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認
- [ ] 他の2FAが残っているかのチェックロジック（two_factor_enabled?）を確認
- [ ] バックアップコードリセット（reset_backup_codes!）の実装を確認
