---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-disabled_two_factor_webauthn_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/profile.rb` 行280-291
- E-02: `app/services/notification_service.rb` 行62-75
- E-03: `app/services/webauthn/destroy_service.rb` 全体
- E-04: `app/services/authn/passkey/destroy_service.rb` 全体
- E-05: `app/views/notify/disabled_two_factor_webauthn_email.html.haml` 全体
- E-06: `app/views/notify/disabled_two_factor_webauthn_email.text.erb` 全体
- E-07: `app/controllers/profiles/two_factor_auths_controller.rb` 行123-131
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行65

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は disabled_two_factor_webauthn_email | E-01, E-08 | ○ |
| C-02 | WebAuthnデバイスまたはパスキー削除時に送信 | E-02 行66-69, E-03, E-04 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02 行67, 69 | ○ |
| C-04 | ユーザーの通知受信可否をチェック | E-02 行63 | ○ |
| C-05 | 件名は「WebAuthn device deleted」または「Passkey deleted」 | E-01 行289 | ○ |
| C-06 | @user, @device_name, @typeがテンプレート変数 | E-01 行283-286 | ○ |
| C-07 | type引数でwebauthnとpasskeyを区別 | E-01 行280, E-02 行66-69 | ○ |
| C-08 | テンプレートはHTMLとテキストの両方を提供 | E-05, E-06 | ○ |
| C-09 | WebAuthnの場合は二要素認証管理リンクを含む | E-05 行7 | ○ |
| C-10 | パスキーの場合はパスキー管理リンクを含む | E-05 行12 | ○ |
| C-11 | Webauthn::DestroyServiceがWebAuthn削除のエントリーポイント | E-03 | ○ |
| C-12 | Authn::Passkey::DestroyServiceがパスキー削除のエントリーポイント | E-04 | ○ |
| C-13 | notify_on_successで通知を呼び出し | E-03 行42-44, E-04 行32-34 | ○ |
| C-14 | 他の2FAがない場合はバックアップコードリセット | E-03 行21-23 | ○ |
| C-15 | 他の2FAがない場合はdisabled_two_factor_emailも送信 | E-03 行23 | ○ |
| C-16 | デバイス名はサニタイズ処理される | E-06 行4, 8 `sanitize_name` | ○ |
| C-17 | Emails::Profileモジュールで定義 | E-01 行3-4 | ○ |
| C-18 | email_with_layoutでメール生成 | E-01 行287-290 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認
- [ ] デバイス名のサニタイズ処理（sanitize_name）の実装を確認
- [ ] パスキー削除でバックアップコードリセットが行われないことの確認（パスキーは2FA外の認証手段）
