---
generated_at: 2026-01-22 14:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-new_email_address_added_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/profile.rb` 行293-300
- E-02: `app/services/notification_service.rb` 行196-200
- E-03: `app/services/emails/create_service.rb` 全体
- E-04: `app/views/notify/new_email_address_added_email.html.haml` 全体
- E-05: `app/views/notify/new_email_address_added_email.text.erb` 全体
- E-06: `app/helpers/emails_helper.rb` 行278-295
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行66

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は new_email_address_added_email | E-01, E-07 | ○ |
| C-02 | セカンダリメール追加時に送信（プライマリは除外） | E-03 行10 `!email.user_primary_email?` | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02 行199 | ○ |
| C-04 | ユーザーの通知受信可否をチェック | E-02 行197 | ○ |
| C-05 | 件名は「New email address added」 | E-01 行299 | ○ |
| C-06 | @user, @emailがテンプレート変数 | E-01 行296-297 | ○ |
| C-07 | テンプレートはHTMLとテキストの両方を提供 | E-04, E-05 | ○ |
| C-08 | Emails::CreateServiceがエントリーポイント | E-03 | ○ |
| C-09 | email.persisted?をチェック | E-03 行10 | ○ |
| C-10 | 内部ユーザー・ゴーストユーザーには送信しない | E-02 行197 | ○ |
| C-11 | Emails::Profileモジュールで定義 | E-01 行3-4 | ○ |
| C-12 | email_with_layoutでメール生成 | E-01 行299 | ○ |
| C-13 | new_email_address_added_textヘルパーを使用 | E-04 行4, E-06 行278-280 | ○ |
| C-14 | remove_email_address_textヘルパーを使用 | E-04 行6, E-06 行282-295 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認
- [ ] user_primary_email?メソッドの実装を確認
- [ ] メールアドレスがHTML内で適切にエスケープされているか確認
