---
generated_at: 2026-01-22 14:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-new_achievement_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/profile.rb` 行302-316
- E-02: `app/services/notification_service.rb` 行773-775
- E-03: `app/services/achievements/award_service.rb` 全体
- E-04: `app/views/notify/new_achievement_email.html.haml` 全体
- E-05: `app/views/notify/new_achievement_email.text.erb` 全体
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行67

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は new_achievement_email | E-01, E-06 | ○ |
| C-02 | アチーブメント授与時に送信 | E-03 行25 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-03 行25 | ○ |
| C-04 | ユーザーのアクティブ状態をチェック | E-01 行303 | ○ |
| C-05 | 件名にnamespace_full_pathとachievement_nameを含む | E-01 行310-313 | ○ |
| C-06 | @user, @achievementがテンプレート変数 | E-01 行305-306 | ○ |
| C-07 | テンプレートはHTMLとテキストの両方を提供 | E-04, E-05 | ○ |
| C-08 | Achievements::AwardServiceがエントリーポイント | E-03 | ○ |
| C-09 | 権限チェック can?(:award_achievement, achievement) | E-03 行33-35 | ○ |
| C-10 | Emails::Profileモジュールで定義 | E-01 行3-4 | ○ |
| C-11 | email_with_layoutでメール生成 | E-01 行308-315 | ○ |
| C-12 | グループ名とプロフィールリンクを含む | E-04 行1-7 | ○ |
| C-13 | NotificationService経由でメーラー呼び出し | E-02, E-03 行25 | ○ |
| C-14 | UserAchievement.createで授与記録を作成 | E-03 行19-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認（s_関数使用）
- [ ] アチーブメント名やグループ名のHTMLエスケープを確認
- [ ] can?(:award_achievement, achievement)の権限ロジックを確認
