---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-project_was_moved_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/projects.rb` 行7-16
- E-02: `app/services/notification_service.rb` 行513-524, 970-976
- E-03: `app/views/notify/project_was_moved_email.html.haml` 全体
- E-04: `app/views/notify/project_was_moved_email.text.erb` 全体
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行68

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は project_was_moved_email | E-01, E-05 | ○ |
| C-02 | プロジェクト移動時に送信 | E-02 行513-524 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02 行522 | ○ |
| C-04 | オーナー・メンテナーに送信 | E-02 行514, 970-976 | ○ |
| C-05 | 件名は「Project was moved」 | E-01 行14 | ○ |
| C-06 | @user, @project, @old_path_with_namespaceがテンプレート変数 | E-01 行8-11 | ○ |
| C-07 | テンプレートはHTMLとテキストの両方を提供 | E-03, E-04 | ○ |
| C-08 | MembersFinderで受信者を取得 | E-02 行970-976 | ○ |
| C-09 | custom_action: :moved_project でフィルタリング | E-02 行515 | ○ |
| C-10 | Emails::Projectsモジュールで定義 | E-01 行3-4 | ○ |
| C-11 | email_with_layoutでメール生成 | E-01 行12-15 | ○ |
| C-12 | SSH URLの更新コマンドを含む | E-03 行9, E-04 行7-8 | ○ |
| C-13 | HTTP URLの更新コマンドを含む | E-03 行9, E-04 行9-10 | ○ |
| C-14 | notification_email_for(group)で送信先を取得 | E-01 行13 | ○ |
| C-15 | 新しいプロジェクトURLへのリンクを含む | E-03 行7-8, E-04 行3-4 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認
- [ ] プロジェクトパスやURLのエスケープ処理を確認
- [ ] MembersFinderのパフォーマンス（大規模プロジェクト）を確認
