---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-project_was_exported_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/projects.rb` 行18-24
- E-02: `app/services/notification_service.rb` 行546-549
- E-03: `app/views/notify/project_was_exported_email.html.haml` 全体
- E-04: `app/views/notify/project_was_exported_email.text.erb` 全体
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行69

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は project_was_exported_email | E-01, E-05 | ○ |
| C-02 | プロジェクトエクスポート成功時に送信 | E-02 行546-549 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02 行549 | ○ |
| C-04 | notifiable?でmentionレベルをチェック | E-02 行547 | ○ |
| C-05 | 件名は「Project was exported」 | E-01 行23 | ○ |
| C-06 | @projectがテンプレート変数 | E-01 行19 | ○ |
| C-07 | テンプレートはHTMLとテキストの両方を提供 | E-03, E-04 | ○ |
| C-08 | ダウンロードリンクを含む | E-03 行4-6, E-04 行3-4 | ○ |
| C-09 | リンク有効期限は24時間 | E-03 行8, E-04 行6 | ○ |
| C-10 | Emails::Projectsモジュールで定義 | E-01 行3-4 | ○ |
| C-11 | email_with_layoutでメール生成 | E-01 行20-23 | ○ |
| C-12 | notification_email_for(group)で送信先を取得 | E-01 行21 | ○ |
| C-13 | download属性付きリンク | E-03 行5 `download=""` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認
- [ ] ダウンロードリンクの有効期限（24時間）の実装を確認
- [ ] エクスポートファイルへのアクセス権限を確認
