---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-project_scheduled_for_deletion

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/projects.rb` 行35-45
- E-02: `app/services/notification_service.rb` 行777-788, 916-924
- E-03: `app/services/namespaces/mark_for_deletion_base_service.rb` 行14-29, 76-78
- E-04: `app/services/projects/mark_for_deletion_service.rb` 行11-13
- E-05: `app/views/notify/project_scheduled_for_deletion.html.haml` 全体
- E-06: `app/views/notify/project_scheduled_for_deletion.text.erb` 全体
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行71

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名は project_scheduled_for_deletion | E-01, E-07 | ○ |
| C-02 | プロジェクト削除予定マーク時に送信 | E-03 行76-78, E-04 行11-13 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02 行786 | ○ |
| C-04 | emails_disabled?でチェック | E-02 行778 | ○ |
| C-05 | 件名は「Project scheduled for deletion」 | E-01 行43 | ○ |
| C-06 | @project, @user, @deletion_due_in_days, @deletion_dateがテンプレート変数 | E-01 行36-39 | ○ |
| C-07 | テンプレートはHTMLとテキストの両方を提供 | E-05, E-06 | ○ |
| C-08 | 削除までの日数を表示 | E-05 行4, E-06 行3 | ○ |
| C-09 | 復元用ダッシュボードリンクを含む | E-05 行6-7, E-06 行7 | ○ |
| C-10 | owners_without_invitesで受信者取得 | E-02 行780, 916-924 | ○ |
| C-11 | オーナーがいない場合グループオーナーにフォールバック | E-02 行919-921 | ○ |
| C-12 | Emails::Projectsモジュールで定義 | E-01 行3-4 | ○ |
| C-13 | email_with_layoutでメール生成 | E-01 行41-44 | ○ |
| C-14 | @user.emailで送信先取得 | E-01 行42 | ○ |
| C-15 | deletion_adjourned_periodから削除期間取得 | E-01 行38 | ○ |
| C-16 | permanent_deletion_date_formattedで日付フォーマット | E-01 行39 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対応するソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 件名の国際化（i18n）対応を確認
- [ ] deletion_adjourned_periodの設定値を確認
- [ ] inactive_dashboard_projects_urlの実装を確認
- [ ] ユーザー名のサニタイズ処理（sanitize_name）を確認
