---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-repository_cleanup_success_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **本文テンプレートの詳細**：ビューファイルが見つからず詳細不明
  2. **リトライ仕様**：Sidekiqデフォルト設定の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/repository_cleanup_worker.rb` - ワーカークラス定義
- E-02: `app/services/projects/cleanup_service.rb` - クリーンアップサービス
- E-03: `app/services/notification_service.rb` - 通知サービス（644-654行目）
- E-04: `app/mailers/emails/projects.rb` - メーラーメソッド（47-55行目）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（71番）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はrepository_cleanup_success_email | E-05 | ○ |
| C-02 | カテゴリはProject | E-05 | ○ |
| C-03 | BFGツール使用後のクリーンアップ通知 | E-02 | ○ |
| C-04 | RepositoryCleanupWorkerが処理実行 | E-01 | ○ |
| C-05 | 非同期送信（deliver_later） | E-03 (647行目) | ○ |
| C-06 | 送信先はuser.notification_email_for(project.group) | E-04 (52行目) | ○ |
| C-07 | 件名は「Project cleanup has completed」 | E-04 (53行目) | ○ |
| C-08 | プロジェクトのメール無効時は送信しない | E-03 (645-646行目) | ○ |
| C-09 | CleanupService.executeで実処理 | E-02 | ○ |
| C-10 | BFGオブジェクトマップ適用処理 | E-02 (55-62行目) | ○ |
| C-11 | ガベージコレクション実行 | E-02 (43行目) | ○ |
| C-12 | リポジトリを読み取り専用に設定 | E-02 (19行目) | ○ |
| C-13 | 処理後にリポジトリを書き込み可能に戻す | E-02 (28行目) | ○ |
| C-14 | mail_with_localeでメール送信 | E-04 (51-54行目) | ○ |
| C-15 | Sidekiqのリトライ設定は3回 | E-01 (8行目) | ○ |
| C-16 | feature_categoryはsource_code_management | E-01 (9行目) | ○ |
| C-17 | 本文テンプレートの詳細内容 | **根拠なし** | △ |
| C-18 | レート制限の具体的な数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビューテンプレートファイルが見つからない
  - 候補：`app/views/notify/repository_cleanup_success_email.html.haml` / `app/views/notify/repository_cleanup_success_email.text.erb`
- レート制限設定
  - 候補：`config/gitlab.yml` / `app/models/application_setting.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信の基本フローは明確に確認済み
- 1: 中リスク - 本文テンプレートの詳細が不明（ビューファイル未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] ビューテンプレートファイルの存在と内容を確認
- [ ] 実際のメール送信テストで本文を確認
- [ ] エラー時のフォールバック動作を確認
