---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：72-repository_cleanup_failure_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **本文テンプレートの詳細**：ビューファイルが見つからず詳細不明
  2. **エラーメッセージのフォーマット**：実際の表示形式の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/repository_cleanup_worker.rb` - ワーカークラス定義（sidekiq_retries_exhausted含む）
- E-02: `app/services/projects/cleanup_service.rb` - クリーンアップサービス（cleanup_afterメソッド）
- E-03: `app/services/notification_service.rb` - 通知サービス（650-654行目）
- E-04: `app/mailers/emails/projects.rb` - メーラーメソッド（57-63行目）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（72番）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はrepository_cleanup_failure_email | E-05 | ○ |
| C-02 | カテゴリはProject | E-05 | ○ |
| C-03 | リトライ失敗時に送信される | E-01 (11-17行目) | ○ |
| C-04 | sidekiq_retries_exhaustedフックで発火 | E-01 (11-17行目) | ○ |
| C-05 | perform_failureメソッドが呼ばれる | E-01 (28-36行目) | ○ |
| C-06 | 非同期送信（deliver_later） | E-03 (653行目) | ○ |
| C-07 | 送信先はuser.notification_email_for(project.group) | E-04 (62行目) | ○ |
| C-08 | 件名は「Project cleanup failure」 | E-04 (62行目) | ○ |
| C-09 | @errorパラメータでエラー情報を受け取る | E-04 (60行目) | ○ |
| C-10 | プロジェクトのメール無効時は送信しない | E-03 (651-652行目) | ○ |
| C-11 | cleanup_afterでリポジトリ復旧 | E-02 (26-29行目) | ○ |
| C-12 | bfg_object_mapを削除 | E-02 (27行目) | ○ |
| C-13 | set_repository_writable!を呼ぶ | E-02 (28行目) | ○ |
| C-14 | Sidekiqのリトライ設定は3回 | E-01 (8行目) | ○ |
| C-15 | RecordNotFoundはスキップ | E-01 (12行目) | ○ |
| C-16 | feature_categoryはsource_code_management | E-01 (9行目) | ○ |
| C-17 | エラーメッセージはmsg['error_message']から取得 | E-01 (14行目) | ○ |
| C-18 | mail_with_localeでメール送信 | E-04 (62行目) | ○ |
| C-19 | 本文テンプレートの詳細内容 | **根拠なし** | △ |
| C-20 | エラーメッセージのサニタイズ処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ビューテンプレートファイルが見つからない
  - 候補：`app/views/notify/repository_cleanup_failure_email.html.haml` / `app/views/notify/repository_cleanup_failure_email.text.erb`
- エラーメッセージのサニタイズ処理の有無
  - 確認箇所：メーラーまたはビューテンプレート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 失敗通知の基本フローは明確に確認済み
- 1: 中リスク - エラーメッセージにセンシティブ情報が含まれる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ビューテンプレートファイルの存在と内容を確認
- [ ] エラーメッセージにセンシティブ情報が含まれないことを確認
- [ ] リポジトリ復旧処理が確実に実行されることを確認
- [ ] 実際のエラー発生時の通知内容を確認
