---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：73-repository_rewrite_history_success_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **レート制限の具体的な数値**：設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/repositories/rewrite_history_worker.rb` - ワーカークラス定義
- E-02: `app/services/repositories/rewrite_history_service.rb` - 履歴書き換えサービス
- E-03: `app/services/notification_service.rb` - 通知サービス（656-660行目）
- E-04: `app/mailers/emails/projects.rb` - メーラーメソッド（65-72行目）
- E-05: `app/views/notify/repository_rewrite_history_success_email.html.haml` - ビューテンプレート
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（73番）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はrepository_rewrite_history_success_email | E-06 | ○ |
| C-02 | カテゴリはProject | E-06 | ○ |
| C-03 | RewriteHistoryWorkerが処理実行 | E-01 | ○ |
| C-04 | 非同期送信（deliver_later） | E-03 (659行目) | ○ |
| C-05 | 送信先はuser.notification_email_for(project.group) | E-04 (69行目) | ○ |
| C-06 | 件名は「Project history rewrite has completed」 | E-04 (70行目) | ○ |
| C-07 | プロジェクトのメール無効時は送信しない | E-03 (657-658行目) | ○ |
| C-08 | RewriteHistoryServiceでGitaly RPC実行 | E-02 (52-64行目) | ○ |
| C-09 | オーナー権限が必要 | E-02 (41-43行目) | ○ |
| C-10 | リポジトリを読み取り専用に設定 | E-02 (45-50行目) | ○ |
| C-11 | 処理後にリポジトリを書き込み可能に戻す | E-02 (63行目) | ○ |
| C-12 | 監査ログが記録される | E-02 (66-89行目) | ○ |
| C-13 | email_with_layoutでメール送信 | E-04 (68-71行目) | ○ |
| C-14 | ワーカーはidempotent! | E-01 (7行目) | ○ |
| C-15 | ワーカーはdeduplicate :until_executed | E-01 (8行目) | ○ |
| C-16 | feature_categoryはsource_code_management | E-01 (11行目) | ○ |
| C-17 | 本文にプロジェクトURLが含まれる | E-05 (2行目) | ○ |
| C-18 | 本文にリポジトリサイズが含まれる | E-05 (4行目) | ○ |
| C-19 | サイズはMiB単位で表示 | E-05 (4行目) | ○ |
| C-20 | blob_oidsとredactionsパラメータを受け取る | E-02 (8行目), E-01 (23-24行目) | ○ |
| C-21 | async_executeでワーカーをキュー | E-02 (18-30行目) | ○ |
| C-22 | レート制限の具体的な数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レート制限設定
  - 候補：`config/gitlab.yml` / `app/models/application_setting.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信の基本フローとテンプレート内容は明確に確認済み
- 0: 低リスク - 監査ログの記録も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のメール送信テストで本文を確認
- [ ] リポジトリサイズの表示フォーマットが適切か確認
- [ ] 監査ログの内容が適切か確認
