---
generated_at: 2026-01-22 14:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：76-repository_push_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **Emails on Pushインテグレーションの詳細設定**：インテグレーションクラスの確認が必要
  2. **トリガー元の詳細フロー**：post-receiveフックからの呼び出し経路の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/gitlab/email/message/repository_push.rb` - RepositoryPushメッセージクラス
- E-02: `app/mailers/emails/projects.rb` - メーラーメソッド（96-113行目）
- E-03: `app/views/notify/repository_push_email.html.haml` - HTMLテンプレート
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（76番）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はrepository_push_email | E-04 | ○ |
| C-02 | カテゴリはProject | E-04 | ○ |
| C-03 | RepositoryPushメッセージクラスを使用 | E-01, E-02 (97-98行目) | ○ |
| C-04 | 必須パラメータはauthor_id, ref, action | E-01 (17-18行目) | ○ |
| C-05 | commitsはcompare.commitsから取得 | E-01 (37-41行目) | ○ |
| C-06 | diffsはcompare.diffsから取得 | E-01 (43-48行目) | ○ |
| C-07 | changed_filesはcompare.changed_pathsから取得 | E-01 (50-54行目) | ○ |
| C-08 | action_nameでpushed to/deleted等を判定 | E-01 (84-94行目) | ○ |
| C-09 | ref_typeでbranch/tagを判定 | E-01 (100-102行目) | ○ |
| C-10 | ref_nameでブランチ/タグ名を取得 | E-01 (96-98行目) | ○ |
| C-11 | subjectメソッドで件名を生成 | E-01 (126-147行目) | ○ |
| C-12 | target_urlで比較/コミットURLを生成 | E-01 (104-116行目) | ○ |
| C-13 | reply_toでコミッターメールを設定可能 | E-01 (118-124行目) | ○ |
| C-14 | reverse_compare?でForce Push判定 | E-01 (72-74行目) | ○ |
| C-15 | disable_diffs?で差分表示制御 | E-01 (76-78行目) | ○ |
| C-16 | send_from_committer_email?で送信元制御 | E-01 (80-82行目) | ○ |
| C-17 | mail_with_localeでメール送信 | E-02 (108-112行目) | ○ |
| C-18 | add_project_headersでヘッダー追加 | E-02 (105行目) | ○ |
| C-19 | X-GitLab-Authorヘッダー追加 | E-02 (106行目) | ○ |
| C-20 | Force Push時の警告表示 | E-03 (9-12行目) | ○ |
| C-21 | コミット一覧の表示 | E-03 (18-24行目) | ○ |
| C-22 | 変更ファイル一覧の表示 | E-03 (30-47行目) | ○ |
| C-23 | Emails on Pushインテグレーションの詳細 | **根拠なし** | △ |
| C-24 | post-receiveフックからの呼び出し経路 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Emails on Pushインテグレーションクラス
  - 候補：`app/models/integrations/emails_on_push.rb`
- post-receiveフックからの呼び出し経路
  - 候補：`lib/gitlab/git/hook.rb` / `app/services/git/base_hooks_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メッセージクラスとメーラーの実装は明確に確認済み
- 1: 中リスク - インテグレーションとフックからの呼び出し経路の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Emails on Pushインテグレーションの設定項目を確認
- [ ] post-receiveフックからの呼び出し経路を確認
- [ ] 実際のプッシュ時の通知内容を確認
- [ ] Force Push時の警告表示を確認
- [ ] 大きな差分の省略動作を確認
