---
generated_at: 2026-01-22 15:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：77-prometheus_alert_fired_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **ProcessPrometheusAlertServiceの詳細フロー**：アラート処理サービスの確認が必要
  2. **HTTP Integrationの詳細**：Prometheusインテグレーション設定の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/alert_management/alert.rb` - アラートモデル（部分）
- E-02: `app/mailers/emails/projects.rb` - メーラーメソッド（115-125行目）
- E-03: `app/services/notification_service.rb` - 通知サービス（676-682行目）
- E-04: `app/views/notify/prometheus_alert_fired_email.html.haml` - HTMLテンプレート
- E-05: `app/services/projects/prometheus/alerts/notify_service.rb` - Webhookハンドラー
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（77番）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はprometheus_alert_fired_email | E-06 | ○ |
| C-02 | カテゴリはProject | E-06 | ○ |
| C-03 | オーナー・メンテナーに送信 | E-03 (679行目) | ○ |
| C-04 | 招待中メンバーは除外 | E-03 (679行目) | ○ |
| C-05 | 非同期送信（deliver_later） | E-03 (680行目) | ○ |
| C-06 | プロジェクトのメール無効時は送信しない | E-03 (677行目) | ○ |
| C-07 | 件名に「Alert:」プレフィックス | E-02 (123行目) | ○ |
| C-08 | @projectパラメータ設定 | E-02 (116行目) | ○ |
| C-09 | @alertパラメータ（present済み） | E-02 (117行目) | ○ |
| C-10 | @incidentパラメータ（alert.issue） | E-02 (118行目) | ○ |
| C-11 | add_project_headers呼び出し | E-02 (120行目) | ○ |
| C-12 | add_alert_headers呼び出し | E-02 (121行目) | ○ |
| C-13 | 発火/解決で本文が変わる | E-04 (1行目) | ○ |
| C-14 | アラート詳細へのリンク表示 | E-04 (6行目) | ○ |
| C-15 | 説明の条件付き表示 | E-04 (8-11行目) | ○ |
| C-16 | 環境名の条件付き表示 | E-04 (13-16行目) | ○ |
| C-17 | インシデントリンクの条件付き表示 | E-04 (18-20行目) | ○ |
| C-18 | X-GitLab-Alert-IDヘッダー | E-02 (144行目) | ○ |
| C-19 | X-GitLab-Alert-IIDヘッダー | E-02 (145行目) | ○ |
| C-20 | X-GitLab-NotificationReasonヘッダー | E-02 (146行目) | ○ |
| C-21 | ProcessPrometheusAlertServiceの詳細フロー | **根拠なし** | △ |
| C-22 | HTTP Integrationの詳細設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AlertManagement::ProcessPrometheusAlertServiceの詳細
  - 候補：`app/services/alert_management/process_prometheus_alert_service.rb`
- HTTP Integrationの設定
  - 候補：`app/models/alert_management/http_integration.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信の基本フローとテンプレート内容は明確に確認済み
- 1: 中リスク - アラート処理サービスの詳細フローの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ProcessPrometheusAlertServiceの実装を確認
- [ ] HTTP Integrationの設定項目を確認
- [ ] 実際のアラート発火時の通知内容を確認
- [ ] アラート解決時の通知内容を確認
- [ ] インシデントリンクの表示条件を確認
