---
generated_at: 2026-01-22 15:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：78-inactive_project_deletion_warning_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **DormantProjectsDeletionWarningTrackerの詳細実装**：Redis操作の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/projects/inactive_projects_deletion_notification_worker.rb` - ワーカークラス定義
- E-02: `app/services/notification_service.rb` - 通知サービス（729-733行目）
- E-03: `app/mailers/emails/projects.rb` - メーラーメソッド（127-137行目）
- E-04: `app/views/notify/inactive_project_deletion_warning_email.html.haml` - HTMLテンプレート
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（78番）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はinactive_project_deletion_warning_email | E-05 | ○ |
| C-02 | カテゴリはProject | E-05 | ○ |
| C-03 | InactiveProjectsDeletionNotificationWorkerが処理実行 | E-01 | ○ |
| C-04 | 通知済みチェックを実行 | E-01 (15行目) | ○ |
| C-05 | 通知済みマークを設定 | E-01 (21行目) | ○ |
| C-06 | Sidekiqリトライは3回 | E-01 (11行目) | ○ |
| C-07 | オーナー・メンテナーに送信 | E-02 (730行目) | ○ |
| C-08 | 非同期送信（deliver_later） | E-02 (731行目) | ○ |
| C-09 | @projectパラメータ設定 | E-03 (128行目) | ○ |
| C-10 | @userパラメータ設定 | E-03 (129行目) | ○ |
| C-11 | @deletion_dateパラメータ設定 | E-03 (130行目) | ○ |
| C-12 | 件名にプロジェクト名と削除日が含まれる | E-03 (131-133行目) | ○ |
| C-13 | email_with_layoutでメール送信 | E-03 (134-136行目) | ○ |
| C-14 | 挨拶文にユーザー名を使用 | E-04 (6行目) | ○ |
| C-15 | プロジェクトへのリンク表示 | E-04 (9行目) | ○ |
| C-16 | 削除予定日を太字で表示 | E-04 (9行目) | ○ |
| C-17 | 削除回避アクションの例を表示 | E-04 (12-16行目) | ○ |
| C-18 | アクティビティ確認方法を表示 | E-04 (18-25行目) | ○ |
| C-19 | Projects APIへの言及 | E-04 (24行目) | ○ |
| C-20 | Events APIへの言及 | E-04 (25行目) | ○ |
| C-21 | 通知上書きの注記 | E-04 (28行目) | ○ |
| C-22 | DormantProjectsDeletionWarningTrackerの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DormantProjectsDeletionWarningTrackerの詳細実装
  - 候補：`lib/gitlab/dormant_projects_deletion_warning_tracker.rb`
  - Redis操作の詳細

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信の基本フローとテンプレート内容は明確に確認済み
- 0: 低リスク - ワーカーの処理フローも明確

## 6) レビュアーチェックリスト（最小）
- [ ] DormantProjectsDeletionWarningTrackerの実装を確認
- [ ] 実際の削除警告メールの内容を確認
- [ ] 削除予定日の計算ロジックを確認
- [ ] 通知済みフラグの有効期限を確認
