---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：79-group_was_exported_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **ダウンロードリンクの有効期限管理**：詳細な実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/groups/import_export/export_service.rb` - エクスポートサービス
- E-02: `app/services/notification_service.rb` - 通知サービス（684-688行目）
- E-03: `app/mailers/emails/groups.rb` - メーラー（7-9行目、15-19行目）
- E-04: `app/views/notify/group_was_exported_email.html.haml` - HTMLテンプレート
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（79番）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はgroup_was_exported_email | E-05 | ○ |
| C-02 | カテゴリはGroup | E-05 | ○ |
| C-03 | ExportServiceがエクスポート処理を実行 | E-01 | ○ |
| C-04 | notify_successでNotificationService呼び出し | E-01 (128-131行目) | ○ |
| C-05 | 非同期送信（deliver_later） | E-02 (687行目) | ○ |
| C-06 | notifiable?チェックを実行 | E-02 (685行目) | ○ |
| C-07 | 件名は「Group was exported」 | E-03 (8行目) | ○ |
| C-08 | @groupパラメータ設定 | E-03 (16行目) | ○ |
| C-09 | mail_with_localeでメール送信 | E-03 (18行目) | ○ |
| C-10 | グループ名がメール本文に含まれる | E-04 (2行目) | ○ |
| C-11 | ダウンロードリンクが含まれる | E-04 (6行目) | ○ |
| C-12 | 24時間の有効期限案内 | E-04 (9行目) | ○ |
| C-13 | 権限チェックを実行 | E-01 (38-44行目) | ○ |
| C-14 | admin_group権限が必要 | E-01 (39行目) | ○ |
| C-15 | 既存エクスポートファイル削除 | E-01 (46-51行目) | ○ |
| C-16 | 監査ログを記録 | E-01 (114-126行目) | ○ |
| C-17 | サイレント管理者エクスポートで監査スキップ | E-01 (115行目) | ○ |
| C-18 | エラー時はnotify_error呼び出し | E-01 (100-103行目) | ○ |
| C-19 | グループフルネームがリンクテキストに使用 | E-04 (7行目) | ○ |
| C-20 | ダウンロードリンクの有効期限管理の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ダウンロードリンクの有効期限管理の詳細実装
  - 候補：`app/models/import_export_upload.rb` / `lib/gitlab/import_export/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信の基本フローとテンプレート内容は明確に確認済み
- 0: 低リスク - エクスポートサービスの処理フローも明確

## 6) レビュアーチェックリスト（最小）
- [ ] ダウンロードリンクの有効期限管理の実装を確認
- [ ] 実際のエクスポート完了メールの内容を確認
- [ ] 監査ログの内容が適切か確認
- [ ] サイレント管理者エクスポートの動作を確認
