---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-changed_milestone_issue_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` - changed_milestoneメソッド（754-771行目）
- E-02: `app/mailers/emails/issues.rb` - changed_milestone_issue_emailメソッド（104-117行目）
- E-03: `app/views/notify/changed_milestone_email.html.haml` - 共通テンプレート（全6行）
- E-04: `app/mailers/notify.rb` - mail_answer_thread（188-196行目）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | changed_milestone_issue_emailはマイルストーン変更通知を送信 | E-01, E-02 | ○ |
| C-02 | NotificationService.changed_milestone()がエントリーポイント | E-01 (754行目) | ○ |
| C-03 | milestone引数が必要 | E-01 (754行目), E-02 (104行目) | ○ |
| C-04 | case文でtargetタイプによりmethod決定 | E-01 (755-760行目) | ○ |
| C-05 | Issue → :changed_milestone_issue_email | E-01 (756-757行目) | ○ |
| C-06 | 非同期送信（deliver_later）を使用 | E-01 (769行目) | ○ |
| C-07 | action: 'changed_milestone'で受信者構築 | E-01 (765行目) | ○ |
| C-08 | setup_issue_mailでインスタンス変数設定 | E-02 (105行目) | ○ |
| C-09 | @milestone設定 | E-02 (107行目) | ○ |
| C-10 | @milestone_url設定 | E-02 (108行目) | ○ |
| C-11 | template_name: 'changed_milestone_email'指定 | E-02 (115行目) | ○ |
| C-12 | mail_answer_threadでスレッド返信形式 | E-02 (109-116行目), E-04 | ○ |
| C-13 | テンプレートでmilestone_link生成 | E-03 (2行目) | ○ |
| C-14 | "Milestone changed to"メッセージ表示 | E-03 (3行目) | ○ |
| C-15 | milestone_date_rangeで期間表示 | E-03 (4-5行目) | ○ |
| C-16 | X-GitLab-ConfidentialIssueヘッダー設定 | E-02 (issue_thread_options) | ○ |
| C-17 | 件名にRe:プレフィックス付与 | E-04 (193行目) | ○ |
| C-18 | SentNotification.recordで送信記録作成 | E-02 (setup_issue_mail内) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信処理の基本フロー
- 0: 低リスク - マイルストーン情報表示

## 6) レビュアーチェックリスト（最小）
- [ ] milestone_date_rangeヘルパーの出力形式確認
- [ ] マイルストーンURLが正しく生成されるか確認
- [ ] マイルストーン変更実行者が通知対象から除外されているか確認
