---
generated_at: 2026-01-22 15:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：80-group_was_not_exported_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **エラーメッセージのサニタイズ処理**：センシティブ情報が含まれないことの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/groups/import_export/export_service.rb` - エクスポートサービス
- E-02: `app/services/notification_service.rb` - 通知サービス（690-694行目）
- E-03: `app/mailers/emails/groups.rb` - メーラー（11-13行目、15-19行目）
- E-04: `app/views/notify/group_was_not_exported_email.html.haml` - HTMLテンプレート
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧（80番）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知名はgroup_was_not_exported_email | E-05 | ○ |
| C-02 | カテゴリはGroup | E-05 | ○ |
| C-03 | ExportServiceでエラー発生時に通知 | E-01 | ○ |
| C-04 | notify_error!でnotify_error呼び出し後に例外発生 | E-01 (100-103行目) | ○ |
| C-05 | notify_errorでNotificationService呼び出し | E-01 (134-142行目) | ○ |
| C-06 | エラーログ記録 | E-01 (135-139行目) | ○ |
| C-07 | 非同期送信（deliver_later） | E-02 (693行目) | ○ |
| C-08 | notifiable?チェックを実行 | E-02 (691行目) | ○ |
| C-09 | 件名は「Group export error」 | E-03 (12行目) | ○ |
| C-10 | @groupパラメータ設定 | E-03 (16行目) | ○ |
| C-11 | @errorsパラメータ設定 | E-03 (17行目) | ○ |
| C-12 | mail_with_localeでメール送信 | E-03 (18行目) | ○ |
| C-13 | グループ名がメール本文に含まれる | E-04 (2行目) | ○ |
| C-14 | エラー一覧がリスト表示される | E-04 (7-10行目) | ○ |
| C-15 | 権限チェックエラー時に通知 | E-01 (38-44行目) | ○ |
| C-16 | エクスポーター失敗時に通知 | E-01 (53-63行目) | ○ |
| C-17 | ファイル保存失敗時に通知 | E-01 (57行目) | ○ |
| C-18 | shared.errorsにエラーが蓄積 | E-01 (40, 139行目) | ○ |
| C-19 | shared.errors.to_sentenceでエラーメッセージ結合 | E-01 (103行目) | ○ |
| C-20 | エラーメッセージのサニタイズ処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- エラーメッセージのサニタイズ処理の有無
  - 確認箇所：メーラーまたはビューテンプレート
  - 内部エラーメッセージにセンシティブ情報が含まれる可能性

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 失敗通知の基本フローとテンプレート内容は明確に確認済み
- 1: 中リスク - エラーメッセージにセンシティブ情報が含まれる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のエラー発生時の通知内容を確認
- [ ] エラーメッセージにセンシティブ情報が含まれないことを確認
- [ ] 各種エラーケースでの通知内容を確認
- [ ] 複数エラー発生時の表示形式を確認
