---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：81-group_scheduled_for_deletion

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **リトライ回数**: Sidekiqデフォルト設定の確認が必要
  2. **EE版追加機能**: EE版での追加機能有無の確認が必要
  3. **遅延削除期間デフォルト値**: 7日間という記載の根拠確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/groups/mark_for_deletion_service.rb`（14-17行目: notification_method定義）
- E-02: `app/services/namespaces/mark_for_deletion_base_service.rb`（76-77行目: send_notification実装）
- E-03: `app/services/notification_service.rb`（790-801行目: group_scheduled_for_deletion実装）
- E-04: `app/mailers/emails/groups.rb`（21-31行目: メーラー実装）
- E-05: `app/views/notify/group_scheduled_for_deletion.text.erb`（テキストテンプレート）
- E-06: `app/views/notify/group_scheduled_for_deletion.html.haml`（HTMLテンプレート）
- E-07: `app/models/member.rb`（222行目: ownersスコープ、172-177行目: active_without_invites_and_requestsスコープ）
- E-08: `app/mailers/application_mailer.rb`（21-22行目: default from設定）
- E-09: `app/mailers/notify.rb`（24行目: Emails::Groupsインクルード）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループ削除予定時にオーナーに通知が送信される | E-01, E-02, E-03 | ○ |
| C-02 | NotificationService#group_scheduled_for_deletionが呼び出される | E-02, E-03 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-03（797-799行目） | ○ |
| C-04 | 受信者はアクティブなオーナーのみ | E-03（793行目）, E-07 | ○ |
| C-05 | emails_disabled?がtrueの場合は送信しない | E-03（791行目） | ○ |
| C-06 | 件名フォーマットは「Group scheduled for deletion」を含む | E-04（29行目） | ○ |
| C-07 | テンプレートにはusername, group_name, days, deletion_dateが含まれる | E-05, E-06 | ○ |
| C-08 | 削除日数はdeletion_adjourned_periodから取得 | E-04（24行目） | ○ |
| C-09 | 保持用URLはグループ設定画面のjs-advanced-settingsアンカーを指す | E-05（4行目）, E-06（6-7行目） | ○ |
| C-10 | Group.findとUser.findでデータ取得 | E-04（22-23行目） | ○ |
| C-11 | email_with_layoutを使用してメール送信 | E-04（27-30行目） | ○ |
| C-12 | 送信元アドレスはGitlab.config.gitlab.email_from | E-08（21行目） | ○ |
| C-13 | MarkForDeletionServiceがエントリーポイント | E-01, E-02 | ○ |
| C-14 | 削除日フォーマットは%B %-d, %Y | E-04（25行目） | ○ |
| C-15 | membersテーブルからオーナーを抽出 | E-03（793行目）, E-07 | ○ |
| C-16 | オーナーはaccess_level = 50（OWNER）で定義 | E-07（222行目） | ○ |
| C-17 | マルチパートメール（HTML/テキスト両対応） | E-05, E-06（両ファイルの存在） | ○ |
| C-18 | permanent_deletion_date_formattedヘルパーを使用 | E-04（25行目） | ○ |
| C-19 | NotifyクラスがEmails::Groupsをインクルード | E-09（24行目） | ○ |
| C-20 | group_urlヘルパーでグループURLを生成 | E-05（3行目）, E-06（4行目） | ○ |
| C-21 | 各オーナーに対してループで送信 | E-03（795-800行目） | ○ |
| C-22 | Sidekiqでジョブキューイング | E-03（deliver_later使用） | ○ |
| C-23 | 招待中・リクエスト中メンバーは除外 | E-07（172-177行目）, E-03（793行目） | ○ |
| C-24 | リトライ回数はSidekiqデフォルト（25回） | **根拠なし** | △ |
| C-25 | 遅延削除期間のデフォルトは7日間 | Gitlab::CurrentSettings参照必要 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-24: Sidekiqのリトライ設定は本ソースコードからは直接確認できない。Sidekiqの設定ファイルまたはドキュメントでの確認が必要。
  - 候補：`config/sidekiq.yml` / Sidekiq公式ドキュメント / GitLab設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 1: 中リスク - Sidekiqリトライ設定の詳細確認が推奨
- 0: 低リスク - テンプレート変数は実際のテンプレートファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（MarkForDeletionService）の確認
- [x] 受信者決定ロジック（オーナーのみ）の確認
- [x] メールテンプレートの内容確認
- [ ] Sidekiqリトライ設定の確認（config/sidekiq.yml等）
- [ ] EE版での追加機能有無の確認
- [x] emails_disabled?による送信抑止の確認
