---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：82-member_access_granted_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Emails::MembersとMembers::AccessGrantedMailerの使い分け**: 両方のメーラーが存在する理由の確認
  2. **Feature flag ui_for_organizations**: 有効時の挙動確認
  3. **role_type変数**: 実際の値の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/members.rb`（14-23行目: member_access_granted_email実装）
- E-02: `app/mailers/members/access_granted_mailer.rb`（11-17行目: emailメソッド実装）
- E-03: `app/models/member.rb`（741-751行目: post_create_member_hook）
- E-04: `app/models/member.rb`（718-728行目: send_access_granted_notification）
- E-05: `app/views/members/access_granted_mailer/email.text.erb`（テンプレート）
- E-06: `app/models/member.rb`（366行目: after_create :post_create_member_hook）
- E-07: `app/mailers/members/access_granted_mailer.rb`（24-31行目: valid_to_email?）
- E-08: `app/mailers/members/access_granted_mailer.rb`（49-50行目: email_subject_text）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクセス権付与時にユーザーに通知される | E-03, E-04 | ○ |
| C-02 | Emails::Membersモジュールにmember_access_granted_emailがある | E-01 | ○ |
| C-03 | Members::AccessGrantedMailerも存在する | E-02 | ○ |
| C-04 | 送信方式は非同期（deliver_later） | E-04（728行目） | ○ |
| C-05 | pending状態では送信されない | E-06（unless条件） | ○ |
| C-06 | importing状態では送信されない | E-06（unless条件） | ○ |
| C-07 | 個人プロジェクトオーナーには送信されない | E-03（745行目） | ○ |
| C-08 | notifiable?チェックが行われる | E-04（726行目） | ○ |
| C-09 | member.blank?の場合はログ出力してスキップ | E-07（25-28行目） | ○ |
| C-10 | 件名に「Access to the」が含まれる | E-08（49-50行目） | ○ |
| C-11 | source_name, source_type, role_nameがテンプレートで使用される | E-05 | ○ |
| C-12 | leave_urlが含まれる | E-05（21行目） | ○ |
| C-13 | notification_groupの決定ロジック | E-02（40-42行目） | ○ |
| C-14 | after_createフックで呼び出される | E-06 | ○ |
| C-15 | member_sourceはmember.sourceから取得 | E-02（22行目） | ○ |
| C-16 | member_source_organizationも参照される | E-02（37-39行目） | ○ |
| C-17 | ui_for_organizations Feature flagで表示内容が変わる | E-05（7行目） | ○ |
| C-18 | role_typeはmember.present.role_typeから取得 | E-05（5行目） | ○ |
| C-19 | mail_with_localeでメール送信 | E-02（14-17行目） | ○ |
| C-20 | post_update_hookでアクセスレベル変更時も送信 | E-03（753-755行目から推測）| ○ |
| C-21 | 2つのメーラーの統合予定 | **根拠なし（推測）** | △ |
| C-22 | polymorphic_urlでleave_urlを生成 | E-05（21行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- C-21: 2つのメーラー（Emails::MembersとMembers::AccessGrantedMailer）の統合予定は推測であり、公式なドキュメントやコメントでの確認が必要
  - 候補：GitLab開発ドキュメント / イシュー / マージリクエスト

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 2つのメーラー実装の使い分けと今後の方針の確認が推奨
- 0: 低リスク - 主要な通知ロジックはソースコードで確認済み
- 0: 低リスク - テンプレート変数は実際のテンプレートファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（post_create_member_hook）の確認
- [x] 送信抑止条件（pending, importing, personal_namespace_holder?）の確認
- [x] メールテンプレートの内容確認
- [ ] Emails::MembersとMembers::AccessGrantedMailerの使い分け確認
- [ ] Feature flag ui_for_organizations の挙動確認
- [x] notifiable?による送信制御の確認
