---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-invite_initial_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビューは低優先度で問題なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/members/invite_mailer.rb`（16-29行目: initial_email実装）
- E-02: `app/models/member.rb`（704-705行目: send_invite）
- E-03: `app/models/member.rb`（596-602行目: resend_invite）
- E-04: `app/models/member.rb`（364行目: after_create :send_invite）
- E-05: `app/views/members/invite_mailer/initial_email.text.erb`（テンプレート）
- E-06: `app/mailers/members/invite_mailer.rb`（39-51行目: email_subject_text）
- E-07: `app/mailers/members/invite_mailer.rb`（53-62行目: email_headers）
- E-08: `app/mailers/members/invite_mailer.rb`（64-68行目: member_exists?）
- E-09: `app/mailers/members/invite_mailer.rb`（12行目: layout 'unknown_user_mailer'）
- E-10: `app/models/member.rb`（586-594行目: generate_invite_token）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 招待作成時にメール送信される | E-02, E-04 | ○ |
| C-02 | Members::InviteMailer.initial_emailが呼び出される | E-01, E-02 | ○ |
| C-03 | 送信方式は非同期（deliver_later） | E-02（705行目） | ○ |
| C-04 | 送信先はmember.invite_email | E-01（25行目） | ○ |
| C-05 | 招待者がいる場合の件名形式 | E-06（41-43行目） | ○ |
| C-06 | 招待者がいない場合の件名形式 | E-06（46-48行目） | ○ |
| C-07 | Tracking.eventでトラッキングされる | E-01（22行目） | ○ |
| C-08 | member_exists?チェックが行われる | E-08 | ○ |
| C-09 | invite_urlがテンプレートで使用される | E-05（10行目） | ○ |
| C-10 | role, role_typeがテンプレートで使用される | E-05（8行目） | ○ |
| C-11 | レイアウトはunknown_user_mailer | E-09 | ○ |
| C-12 | Mailgun有効時にカスタムヘッダーが追加される | E-07 | ○ |
| C-13 | resend_inviteでトークン再生成可能 | E-03（599-600行目） | ○ |
| C-14 | generate_invite_token!でトークン生成 | E-10 | ○ |
| C-15 | invite?がfalseの場合は送信されない | E-03（597行目） | ○ |
| C-16 | member.blank?の場合はログ出力 | E-08（65行目） | ○ |
| C-17 | created_byから招待者名を取得 | E-06（43行目） | ○ |
| C-18 | member_sourceからプロジェクト/グループ情報を取得 | E-01（35-37行目） | ○ |
| C-19 | invited_to_descriptionでデフォルト説明文を生成 | E-01（70-86行目） | ○ |
| C-20 | after_createフックでif: :invite?条件 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対して根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 0: 低リスク - テンプレート変数は実際のテンプレートファイルで確認済み
- 0: 低リスク - Mailgun連携の条件分岐も確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガー（after_create :send_invite）の確認
- [x] 送信先決定ロジック（invite_email）の確認
- [x] メールテンプレートの内容確認
- [x] 件名の条件分岐（招待者有無）の確認
- [x] トークン生成・管理の確認
- [x] Mailgun連携ヘッダーの確認
