---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-access_denied_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。レビューは低優先度で問題なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/members/access_denied_mailer.rb`（11-18行目: emailメソッド実装）
- E-02: `app/mailers/members/access_denied_mailer.rb`（25-27行目: source_hidden?）
- E-03: `app/mailers/members/access_denied_mailer.rb`（33-36行目: email_subject_text）
- E-04: `app/views/members/access_denied_mailer/email.text.erb`（テンプレート）
- E-05: `app/mailers/members/access_denied_mailer.rb`（9行目: layout 'mailer'）
- E-06: `app/mailers/members/access_denied_mailer.rb`（29-31行目: member取得）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクセスリクエスト拒否時にメール送信される | E-01 | ○ |
| C-02 | Members::AccessDeniedMailer.emailが呼び出される | E-01 | ○ |
| C-03 | notifiable?(:subscription)チェックが行われる | E-01（12行目） | ○ |
| C-04 | 送信先はuser.notification_email_for | E-01（15行目） | ○ |
| C-05 | source_hidden?でプライバシー保護される | E-02 | ○ |
| C-06 | readable_by?でソース閲覧権限を判定 | E-02（26行目） | ○ |
| C-07 | 件名に「was denied」が含まれる | E-03（36行目） | ○ |
| C-08 | ソースが非表示の場合は「Hidden」が使用される | E-03（34行目）, E-04（1行目） | ○ |
| C-09 | ソースが非表示の場合はURLが省略される | E-04（3行目） | ○ |
| C-10 | レイアウトは'mailer' | E-05 | ○ |
| C-11 | params[:member]でMemberが渡される | E-06 | ○ |
| C-12 | mail_with_localeでメール送信 | E-01（14-17行目） | ○ |
| C-13 | member_sourceはmember.sourceから取得 | E-01（22行目delegate） | ○ |
| C-14 | userはmember.userから取得 | E-01（23行目delegate） | ○ |
| C-15 | 本文にrequest to joinが含まれる | E-04（1行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対して根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な通知ロジックはすべてソースコードで確認済み
- 0: 低リスク - プライバシー保護ロジックも確認済み
- 0: 低リスク - テンプレート変数は実際のテンプレートファイルで確認済み

## 6) レビュアーチェックリスト（最小）
- [x] 通知トリガーの確認
- [x] 送信先決定ロジック（notification_email_for）の確認
- [x] プライバシー保護（source_hidden?）の確認
- [x] メールテンプレートの内容確認
- [x] notifiable?による送信制御の確認
